/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.editionlock;

import com.chutneytesting.design.api.editionlock.TestCaseEditionDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableTestCaseEditionDto
implements TestCaseEditionDto {
    private final String testCaseId;
    private final Integer testCaseVersion;
    private final Instant editionStartDate;
    private final String editionUser;

    private ImmutableTestCaseEditionDto(String testCaseId, Integer testCaseVersion, Instant editionStartDate, String editionUser) {
        this.testCaseId = testCaseId;
        this.testCaseVersion = testCaseVersion;
        this.editionStartDate = editionStartDate;
        this.editionUser = editionUser;
    }

    @Override
    @JsonProperty(value="testCaseId")
    public String testCaseId() {
        return this.testCaseId;
    }

    @Override
    @JsonProperty(value="testCaseVersion")
    public Integer testCaseVersion() {
        return this.testCaseVersion;
    }

    @Override
    @JsonProperty(value="editionStartDate")
    public Instant editionStartDate() {
        return this.editionStartDate;
    }

    @Override
    @JsonProperty(value="editionUser")
    public String editionUser() {
        return this.editionUser;
    }

    public final ImmutableTestCaseEditionDto withTestCaseId(String value) {
        if (this.testCaseId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "testCaseId");
        return new ImmutableTestCaseEditionDto(newValue, this.testCaseVersion, this.editionStartDate, this.editionUser);
    }

    public final ImmutableTestCaseEditionDto withTestCaseVersion(Integer value) {
        if (this.testCaseVersion.equals(value)) {
            return this;
        }
        Integer newValue = Objects.requireNonNull(value, "testCaseVersion");
        return new ImmutableTestCaseEditionDto(this.testCaseId, newValue, this.editionStartDate, this.editionUser);
    }

    public final ImmutableTestCaseEditionDto withEditionStartDate(Instant value) {
        if (this.editionStartDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "editionStartDate");
        return new ImmutableTestCaseEditionDto(this.testCaseId, this.testCaseVersion, newValue, this.editionUser);
    }

    public final ImmutableTestCaseEditionDto withEditionUser(String value) {
        if (this.editionUser.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "editionUser");
        return new ImmutableTestCaseEditionDto(this.testCaseId, this.testCaseVersion, this.editionStartDate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTestCaseEditionDto && this.equalTo((ImmutableTestCaseEditionDto)another);
    }

    private boolean equalTo(ImmutableTestCaseEditionDto another) {
        return this.testCaseId.equals(another.testCaseId) && this.testCaseVersion.equals(another.testCaseVersion) && this.editionStartDate.equals(another.editionStartDate) && this.editionUser.equals(another.editionUser);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.testCaseId.hashCode();
        h += (h << 5) + this.testCaseVersion.hashCode();
        h += (h << 5) + this.editionStartDate.hashCode();
        h += (h << 5) + this.editionUser.hashCode();
        return h;
    }

    public String toString() {
        return "TestCaseEditionDto{testCaseId=" + this.testCaseId + ", testCaseVersion=" + this.testCaseVersion + ", editionStartDate=" + this.editionStartDate + ", editionUser=" + this.editionUser + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTestCaseEditionDto fromJson(Json json) {
        Builder builder = ImmutableTestCaseEditionDto.builder();
        if (json.testCaseId != null) {
            builder.testCaseId(json.testCaseId);
        }
        if (json.testCaseVersion != null) {
            builder.testCaseVersion(json.testCaseVersion);
        }
        if (json.editionStartDate != null) {
            builder.editionStartDate(json.editionStartDate);
        }
        if (json.editionUser != null) {
            builder.editionUser(json.editionUser);
        }
        return builder.build();
    }

    public static ImmutableTestCaseEditionDto copyOf(TestCaseEditionDto instance) {
        if (instance instanceof ImmutableTestCaseEditionDto) {
            return (ImmutableTestCaseEditionDto)instance;
        }
        return ImmutableTestCaseEditionDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEST_CASE_ID = 1L;
        private static final long INIT_BIT_TEST_CASE_VERSION = 2L;
        private static final long INIT_BIT_EDITION_START_DATE = 4L;
        private static final long INIT_BIT_EDITION_USER = 8L;
        private long initBits = 15L;
        @Nullable
        private String testCaseId;
        @Nullable
        private Integer testCaseVersion;
        @Nullable
        private Instant editionStartDate;
        @Nullable
        private String editionUser;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TestCaseEditionDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.testCaseId(instance.testCaseId());
            this.testCaseVersion(instance.testCaseVersion());
            this.editionStartDate(instance.editionStartDate());
            this.editionUser(instance.editionUser());
            return this;
        }

        @JsonProperty(value="testCaseId")
        @CanIgnoreReturnValue
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = Objects.requireNonNull(testCaseId, "testCaseId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="testCaseVersion")
        @CanIgnoreReturnValue
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = Objects.requireNonNull(testCaseVersion, "testCaseVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="editionStartDate")
        @CanIgnoreReturnValue
        public final Builder editionStartDate(Instant editionStartDate) {
            this.editionStartDate = Objects.requireNonNull(editionStartDate, "editionStartDate");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="editionUser")
        @CanIgnoreReturnValue
        public final Builder editionUser(String editionUser) {
            this.editionUser = Objects.requireNonNull(editionUser, "editionUser");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTestCaseEditionDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTestCaseEditionDto(this.testCaseId, this.testCaseVersion, this.editionStartDate, this.editionUser);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("testCaseId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("testCaseVersion");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("editionStartDate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("editionUser");
            }
            return "Cannot build TestCaseEditionDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TestCaseEditionDto {
        @Nullable
        String testCaseId;
        @Nullable
        Integer testCaseVersion;
        @Nullable
        Instant editionStartDate;
        @Nullable
        String editionUser;

        Json() {
        }

        @JsonProperty(value="testCaseId")
        public void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @JsonProperty(value="testCaseVersion")
        public void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @JsonProperty(value="editionStartDate")
        public void setEditionStartDate(Instant editionStartDate) {
            this.editionStartDate = editionStartDate;
        }

        @JsonProperty(value="editionUser")
        public void setEditionUser(String editionUser) {
            this.editionUser = editionUser;
        }

        @Override
        public String testCaseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer testCaseVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant editionStartDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String editionUser() {
            throw new UnsupportedOperationException();
        }
    }
}

