/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.dataset;

import com.chutneytesting.design.api.dataset.DataSetDto;
import com.chutneytesting.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableDataSetDto
implements DataSetDto {
    @Nullable
    private final String id;
    private final String name;
    private final Integer version;
    private final String description;
    private final Instant lastUpdated;
    private final List<String> tags;
    private final List<KeyValue> uniqueValues;
    private final List<List<KeyValue>> multipleValues;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDataSetDto(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        if (builder.version != null) {
            this.initShim.version(builder.version);
        }
        if (builder.description != null) {
            this.initShim.description(builder.description);
        }
        if (builder.lastUpdated != null) {
            this.initShim.lastUpdated(builder.lastUpdated);
        }
        if (builder.tagsIsSet()) {
            this.initShim.tags(ImmutableDataSetDto.createUnmodifiableList(true, builder.tags));
        }
        if (builder.uniqueValuesIsSet()) {
            this.initShim.uniqueValues(ImmutableDataSetDto.createUnmodifiableList(true, builder.uniqueValues));
        }
        if (builder.multipleValuesIsSet()) {
            this.initShim.multipleValues(ImmutableDataSetDto.createUnmodifiableList(true, builder.multipleValues));
        }
        this.version = this.initShim.version();
        this.description = this.initShim.description();
        this.lastUpdated = this.initShim.lastUpdated();
        this.tags = this.initShim.tags();
        this.uniqueValues = this.initShim.uniqueValues();
        this.multipleValues = this.initShim.multipleValues();
        this.initShim = null;
    }

    private ImmutableDataSetDto(@Nullable String id, String name, Integer version, String description, Instant lastUpdated, List<String> tags, List<KeyValue> uniqueValues, List<List<KeyValue>> multipleValues) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = description;
        this.lastUpdated = lastUpdated;
        this.tags = tags;
        this.uniqueValues = uniqueValues;
        this.multipleValues = multipleValues;
        this.initShim = null;
    }

    private Integer versionInitialize() {
        return DataSetDto.super.version();
    }

    private String descriptionInitialize() {
        return DataSetDto.super.description();
    }

    private Instant lastUpdatedInitialize() {
        return DataSetDto.super.lastUpdated();
    }

    private List<String> tagsInitialize() {
        return DataSetDto.super.tags();
    }

    private List<KeyValue> uniqueValuesInitialize() {
        return DataSetDto.super.uniqueValues();
    }

    private List<List<KeyValue>> multipleValuesInitialize() {
        return DataSetDto.super.multipleValues();
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="version")
    public Integer version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        InitShim shim = this.initShim;
        return shim != null ? shim.description() : this.description;
    }

    @Override
    @JsonProperty(value="lastUpdated")
    public Instant lastUpdated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastUpdated() : this.lastUpdated;
    }

    @Override
    @JsonProperty(value="tags")
    public List<String> tags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tags() : this.tags;
    }

    @Override
    @JsonProperty(value="uniqueValues")
    public List<KeyValue> uniqueValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uniqueValues() : this.uniqueValues;
    }

    @Override
    @JsonProperty(value="multipleValues")
    public List<List<KeyValue>> multipleValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.multipleValues() : this.multipleValues;
    }

    public final ImmutableDataSetDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(newValue, this.name, this.version, this.description, this.lastUpdated, this.tags, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableDataSetDto(value, this.name, this.version, this.description, this.lastUpdated, this.tags, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "name");
        return new ImmutableDataSetDto(this.id, newValue, this.version, this.description, this.lastUpdated, this.tags, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withVersion(Integer value) {
        if (this.version.equals(value)) {
            return this;
        }
        Integer newValue = Objects.requireNonNull(value, "version");
        return new ImmutableDataSetDto(this.id, this.name, newValue, this.description, this.lastUpdated, this.tags, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withDescription(String value) {
        if (this.description.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "description");
        return new ImmutableDataSetDto(this.id, this.name, this.version, newValue, this.lastUpdated, this.tags, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withLastUpdated(Instant value) {
        if (this.lastUpdated == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "lastUpdated");
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, newValue, this.tags, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withTags(String ... elements) {
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, newValue, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, newValue, this.uniqueValues, this.multipleValues);
    }

    public final ImmutableDataSetDto withUniqueValues(KeyValue ... elements) {
        List<KeyValue> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, newValue, this.multipleValues);
    }

    public final ImmutableDataSetDto withUniqueValues(Iterable<? extends KeyValue> elements) {
        if (this.uniqueValues == elements) {
            return this;
        }
        List<KeyValue> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, newValue, this.multipleValues);
    }

    @SafeVarargs
    public final ImmutableDataSetDto withMultipleValues(List<KeyValue> ... elements) {
        List<List<KeyValue>> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, this.uniqueValues, newValue);
    }

    public final ImmutableDataSetDto withMultipleValues(Iterable<? extends List<KeyValue>> elements) {
        if (this.multipleValues == elements) {
            return this;
        }
        List<List<KeyValue>> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, this.uniqueValues, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDataSetDto && this.equalTo((ImmutableDataSetDto)another);
    }

    private boolean equalTo(ImmutableDataSetDto another) {
        return Objects.equals(this.id, another.id) && this.name.equals(another.name) && this.version.equals(another.version) && this.description.equals(another.description) && this.lastUpdated.equals(another.lastUpdated) && this.tags.equals(another.tags) && this.uniqueValues.equals(another.uniqueValues) && this.multipleValues.equals(another.multipleValues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.lastUpdated.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.uniqueValues.hashCode();
        h += (h << 5) + this.multipleValues.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DataSetDto{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("lastUpdated=").append(this.lastUpdated);
        builder.append(", ");
        builder.append("tags=").append(this.tags);
        builder.append(", ");
        builder.append("uniqueValues=").append(this.uniqueValues);
        builder.append(", ");
        builder.append("multipleValues=").append(this.multipleValues);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDataSetDto fromJson(Json json) {
        Builder builder = ImmutableDataSetDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.lastUpdated != null) {
            builder.lastUpdated(json.lastUpdated);
        }
        if (json.tagsIsSet) {
            builder.addAllTags(json.tags);
        }
        if (json.uniqueValuesIsSet) {
            builder.addAllUniqueValues(json.uniqueValues);
        }
        if (json.multipleValuesIsSet) {
            builder.addAllMultipleValues(json.multipleValues);
        }
        return builder.build();
    }

    public static ImmutableDataSetDto copyOf(DataSetDto instance) {
        if (instance instanceof ImmutableDataSetDto) {
            return (ImmutableDataSetDto)instance;
        }
        return ImmutableDataSetDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_TAGS = 1L;
        private static final long OPT_BIT_UNIQUE_VALUES = 2L;
        private static final long OPT_BIT_MULTIPLE_VALUES = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Integer version;
        @Nullable
        private String description;
        @Nullable
        private Instant lastUpdated;
        private List<String> tags = new ArrayList<String>();
        private List<KeyValue> uniqueValues = new ArrayList<KeyValue>();
        private List<List<KeyValue>> multipleValues = new ArrayList<List<KeyValue>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DataSetDto instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.name(instance.name());
            this.version(instance.version());
            this.description(instance.description());
            this.lastUpdated(instance.lastUpdated());
            this.addAllTags(instance.tags());
            this.addAllUniqueValues(instance.uniqueValues());
            this.addAllMultipleValues(instance.multipleValues());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="lastUpdated")
        @CanIgnoreReturnValue
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated, "lastUpdated");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUniqueValues(KeyValue element) {
            this.uniqueValues.add(Objects.requireNonNull(element, "uniqueValues element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUniqueValues(KeyValue ... elements) {
            for (KeyValue element : elements) {
                this.uniqueValues.add(Objects.requireNonNull(element, "uniqueValues element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="uniqueValues")
        @CanIgnoreReturnValue
        public final Builder uniqueValues(Iterable<? extends KeyValue> elements) {
            this.uniqueValues.clear();
            return this.addAllUniqueValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUniqueValues(Iterable<? extends KeyValue> elements) {
            for (KeyValue keyValue : elements) {
                this.uniqueValues.add(Objects.requireNonNull(keyValue, "uniqueValues element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMultipleValues(List<KeyValue> element) {
            this.multipleValues.add(Objects.requireNonNull(element, "multipleValues element"));
            this.optBits |= 4L;
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addMultipleValues(List<KeyValue> ... elements) {
            for (List<KeyValue> element : elements) {
                this.multipleValues.add(Objects.requireNonNull(element, "multipleValues element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="multipleValues")
        @CanIgnoreReturnValue
        public final Builder multipleValues(Iterable<? extends List<KeyValue>> elements) {
            this.multipleValues.clear();
            return this.addAllMultipleValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMultipleValues(Iterable<? extends List<KeyValue>> elements) {
            for (List<KeyValue> list : elements) {
                this.multipleValues.add(Objects.requireNonNull(list, "multipleValues element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public ImmutableDataSetDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDataSetDto(this);
        }

        private boolean tagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean uniqueValuesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean multipleValuesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build DataSetDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DataSetDto {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String name;
        @Nullable
        Integer version;
        @Nullable
        String description;
        @Nullable
        Instant lastUpdated;
        @Nullable
        List<String> tags = Collections.emptyList();
        boolean tagsIsSet;
        @Nullable
        List<KeyValue> uniqueValues = Collections.emptyList();
        boolean uniqueValuesIsSet;
        @Nullable
        List<List<KeyValue>> multipleValues = Collections.emptyList();
        boolean multipleValuesIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="lastUpdated")
        public void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
            this.tagsIsSet = true;
        }

        @JsonProperty(value="uniqueValues")
        public void setUniqueValues(List<KeyValue> uniqueValues) {
            this.uniqueValues = uniqueValues;
            this.uniqueValuesIsSet = true;
        }

        @JsonProperty(value="multipleValues")
        public void setMultipleValues(List<List<KeyValue>> multipleValues) {
            this.multipleValues = multipleValues;
            this.multipleValuesIsSet = true;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant lastUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<KeyValue> uniqueValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<List<KeyValue>> multipleValues() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private Integer version;
        private int versionBuildStage;
        private String description;
        private int descriptionBuildStage;
        private Instant lastUpdated;
        private int lastUpdatedBuildStage;
        private List<String> tags;
        private int tagsBuildStage;
        private List<KeyValue> uniqueValues;
        private int uniqueValuesBuildStage;
        private List<List<KeyValue>> multipleValues;
        private int multipleValuesBuildStage;

        private InitShim() {
        }

        Integer version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = -1;
                this.version = Objects.requireNonNull(ImmutableDataSetDto.this.versionInitialize(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(Integer version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        String description() {
            if (this.descriptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionBuildStage == 0) {
                this.descriptionBuildStage = -1;
                this.description = Objects.requireNonNull(ImmutableDataSetDto.this.descriptionInitialize(), "description");
                this.descriptionBuildStage = 1;
            }
            return this.description;
        }

        void description(String description) {
            this.description = description;
            this.descriptionBuildStage = 1;
        }

        Instant lastUpdated() {
            if (this.lastUpdatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastUpdatedBuildStage == 0) {
                this.lastUpdatedBuildStage = -1;
                this.lastUpdated = Objects.requireNonNull(ImmutableDataSetDto.this.lastUpdatedInitialize(), "lastUpdated");
                this.lastUpdatedBuildStage = 1;
            }
            return this.lastUpdated;
        }

        void lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.lastUpdatedBuildStage = 1;
        }

        List<String> tags() {
            if (this.tagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsBuildStage == 0) {
                this.tagsBuildStage = -1;
                this.tags = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.tagsInitialize(), true, false));
                this.tagsBuildStage = 1;
            }
            return this.tags;
        }

        void tags(List<String> tags) {
            this.tags = tags;
            this.tagsBuildStage = 1;
        }

        List<KeyValue> uniqueValues() {
            if (this.uniqueValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uniqueValuesBuildStage == 0) {
                this.uniqueValuesBuildStage = -1;
                this.uniqueValues = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.uniqueValuesInitialize(), true, false));
                this.uniqueValuesBuildStage = 1;
            }
            return this.uniqueValues;
        }

        void uniqueValues(List<KeyValue> uniqueValues) {
            this.uniqueValues = uniqueValues;
            this.uniqueValuesBuildStage = 1;
        }

        List<List<KeyValue>> multipleValues() {
            if (this.multipleValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.multipleValuesBuildStage == 0) {
                this.multipleValuesBuildStage = -1;
                this.multipleValues = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.multipleValuesInitialize(), true, false));
                this.multipleValuesBuildStage = 1;
            }
            return this.multipleValues;
        }

        void multipleValues(List<List<KeyValue>> multipleValues) {
            this.multipleValues = multipleValues;
            this.multipleValuesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.descriptionBuildStage == -1) {
                attributes.add("description");
            }
            if (this.lastUpdatedBuildStage == -1) {
                attributes.add("lastUpdated");
            }
            if (this.tagsBuildStage == -1) {
                attributes.add("tags");
            }
            if (this.uniqueValuesBuildStage == -1) {
                attributes.add("uniqueValues");
            }
            if (this.multipleValuesBuildStage == -1) {
                attributes.add("multipleValues");
            }
            return "Cannot build DataSetDto, attribute initializers form cycle" + attributes;
        }
    }
}

