/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.dataset;

import com.chutneytesting.design.api.dataset.ImmutableDataSetDto;
import com.chutneytesting.tools.ui.KeyValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableDataSetDto.class)
@JsonDeserialize(as=ImmutableDataSetDto.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface DataSetDto {
    public static final Comparator<DataSetDto> dataSetComparator = Comparator.comparing(DataSetDto::name, String.CASE_INSENSITIVE_ORDER);

    public Optional<String> id();

    public String name();

    @Value.Default
    default public Integer version() {
        return 0;
    }

    @Value.Default
    default public String description() {
        return "";
    }

    @Value.Default
    default public Instant lastUpdated() {
        return Instant.now();
    }

    @Value.Default
    default public List<String> tags() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<KeyValue> uniqueValues() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<List<KeyValue>> multipleValues() {
        return Collections.emptyList();
    }
}

