/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.dataset;

import com.chutneytesting.design.api.dataset.DataSetDto;
import com.chutneytesting.design.api.dataset.DataSetMapper;
import com.chutneytesting.design.domain.dataset.DataSet;
import com.chutneytesting.design.domain.dataset.DataSetHistoryRepository;
import com.chutneytesting.design.domain.dataset.DataSetNotFoundException;
import com.chutneytesting.design.domain.dataset.DataSetRepository;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/datasets"})
@CrossOrigin(origins={"*"})
public class DataSetController {
    public static final String BASE_URL = "/api/v1/datasets";
    private DataSetRepository dataSetRepository;
    private DataSetHistoryRepository dataSetHistoryRepository;

    public DataSetController(DataSetRepository dataSetRepository, DataSetHistoryRepository dataSetHistoryRepository) {
        this.dataSetRepository = dataSetRepository;
        this.dataSetHistoryRepository = dataSetHistoryRepository;
    }

    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public List<DataSetDto> findAll() {
        return this.dataSetRepository.findAll().stream().map(ds -> DataSetMapper.toDto(ds, this.lastVersionNumber(ds.id))).sorted(DataSetDto.dataSetComparator).collect(Collectors.toList());
    }

    @PostMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public DataSetDto save(@RequestBody DataSetDto dataSetDto) {
        DataSet newDataSet = DataSetMapper.fromDto(dataSetDto);
        String newDataSetId = this.dataSetRepository.save(newDataSet);
        newDataSet = DataSet.builder().fromDataSet(newDataSet).withId(newDataSetId).build();
        Optional<Pair<String, Integer>> savedVersion = this.dataSetHistoryRepository.addVersion(newDataSet);
        return DataSetMapper.toDto(newDataSet, savedVersion.map(Pair::getRight).orElseGet(() -> this.lastVersionNumber(newDataSetId)));
    }

    @PutMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public DataSetDto update(@RequestBody DataSetDto dataSetDto) {
        DataSet dataSetToUpdate = DataSetMapper.fromDto(dataSetDto);
        return Optional.ofNullable(dataSetToUpdate.id).map(id -> {
            Optional<Pair<String, Integer>> savedVersion = this.dataSetHistoryRepository.addVersion(dataSetToUpdate);
            if (savedVersion.isPresent()) {
                this.dataSetRepository.save(dataSetToUpdate);
                return DataSetMapper.toDto(dataSetToUpdate, (Integer)savedVersion.get().getRight());
            }
            return this.findById((String)id);
        }).orElseThrow(() -> new DataSetNotFoundException(null));
    }

    @DeleteMapping(path={"/{dataSetId}"})
    public void deleteById(@PathVariable String dataSetId) {
        String dataSetBackId = ComposableIdUtils.fromFrontId(dataSetId);
        this.dataSetRepository.removeById(dataSetBackId);
        this.dataSetHistoryRepository.removeHistory(dataSetBackId);
    }

    @GetMapping(path={"/{dataSetId}"}, produces={"application/json;charset=UTF-8"})
    public DataSetDto findById(@PathVariable String dataSetId) {
        return DataSetMapper.toDto(this.dataSetRepository.findById(ComposableIdUtils.fromFrontId(dataSetId)), this.lastVersionNumber(dataSetId));
    }

    @GetMapping(path={"/{dataSetId}/versions/last"}, produces={"application/json;charset=UTF-8"})
    public Integer lastVersionNumber(@PathVariable String dataSetId) {
        return this.dataSetHistoryRepository.lastVersion(ComposableIdUtils.fromFrontId(dataSetId));
    }

    @GetMapping(path={"/{dataSetId}/versions"}, produces={"application/json;charset=UTF-8"})
    public List<DataSetDto> allVersionNumbers(@PathVariable String dataSetId) {
        return this.dataSetHistoryRepository.allVersions(ComposableIdUtils.fromFrontId(dataSetId)).entrySet().stream().map(e -> DataSetMapper.toDto((DataSet)e.getValue(), (Integer)e.getKey())).collect(Collectors.toList());
    }

    @GetMapping(path={"/{dataSetId}/{version}", "/{dataSetId}/versions/{version}"}, produces={"application/json;charset=UTF-8"})
    public DataSetDto version(@PathVariable String dataSetId, @PathVariable Integer version) {
        return DataSetMapper.toDto(this.dataSetHistoryRepository.version(ComposableIdUtils.fromFrontId(dataSetId), version), version);
    }
}

