/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.campaign.dto;

import com.chutneytesting.design.api.campaign.dto.CampaignDto;
import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportDto;
import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportMapper;
import com.chutneytesting.design.domain.campaign.Campaign;
import com.chutneytesting.design.domain.campaign.CampaignExecutionReport;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CampaignMapper {
    public static CampaignDto toDtoWithoutReport(Campaign campaign) {
        return new CampaignDto(campaign.id, campaign.title, campaign.description, campaign.scenarioIds.stream().map(ComposableIdUtils::toFrontId).collect(Collectors.toList()), campaign.dataSet, Collections.emptyList(), campaign.getStringScheduleTime(), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, ComposableIdUtils.toFrontId(campaign.datasetId));
    }

    public static CampaignDto toDto(Campaign campaign, List<CampaignExecutionReport> campaignExecutionReports) {
        return new CampaignDto(campaign.id, campaign.title, campaign.description, campaign.scenarioIds.stream().map(ComposableIdUtils::toFrontId).collect(Collectors.toList()), campaign.dataSet, CampaignMapper.reportToDto(campaignExecutionReports), campaign.getStringScheduleTime(), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, ComposableIdUtils.toFrontId(campaign.datasetId));
    }

    public static Campaign fromDto(CampaignDto dto) {
        return new Campaign(dto.getId(), dto.getTitle(), dto.getDescription(), dto.getScenarioIds().stream().map(id -> ComposableIdUtils.fromFrontId(Optional.of(id))).collect(Collectors.toList()), dto.getComputedParameters(), dto.safeGetScheduleTime().map(LocalTime::parse).orElse(null), dto.getEnvironment(), dto.isParallelRun(), dto.isRetryAuto(), ComposableIdUtils.fromFrontId(dto.getDatasetId()));
    }

    private static List<CampaignExecutionReportDto> reportToDto(List<CampaignExecutionReport> campaignExecutionReports) {
        return campaignExecutionReports != null ? campaignExecutionReports.stream().map(CampaignExecutionReportMapper::toDto).collect(Collectors.toList()) : Collections.emptyList();
    }
}

