/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.campaign.dto;

import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CampaignDto {
    private final Long id;
    private final String title;
    private final String description;
    private final List<String> scenarioIds;
    private final Map<String, String> computedParameters;
    private final List<CampaignExecutionReportDto> campaignExecutionReports;
    private final String scheduleTime;
    private final String environment;
    private final boolean parallelRun;
    private final boolean retryAuto;
    private final String datasetId;

    public CampaignDto(@JsonProperty(value="id") Long id, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="scenarioIds") List<String> scenarioIds, @JsonProperty(value="computedParameters") Map<String, String> computedParameters, @JsonProperty(value="campaignExecutionReports") List<CampaignExecutionReportDto> campaignExecutionReports, @JsonProperty(value="scheduleTime") String scheduleTime, @JsonProperty(value="environment") String environment, @JsonProperty(value="parallelRun") boolean parallelRun, @JsonProperty(value="retryAuto") boolean retryAuto, @JsonProperty(value="datasetId") String datasetId) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.scenarioIds = scenarioIds;
        this.computedParameters = computedParameters;
        this.campaignExecutionReports = Optional.ofNullable(campaignExecutionReports).orElseGet(ArrayList::new);
        this.scheduleTime = scheduleTime;
        this.environment = environment;
        this.parallelRun = parallelRun;
        this.retryAuto = retryAuto;
        this.datasetId = datasetId;
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getScenarioIds() {
        return this.scenarioIds;
    }

    public Map<String, String> getComputedParameters() {
        return this.computedParameters;
    }

    public List<CampaignExecutionReportDto> getCampaignExecutionReports() {
        return this.campaignExecutionReports;
    }

    public String getScheduleTime() {
        return this.scheduleTime;
    }

    public Optional<String> safeGetScheduleTime() {
        if (this.scheduleTime == null || this.scheduleTime.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.scheduleTime);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isParallelRun() {
        return this.parallelRun;
    }

    public boolean isRetryAuto() {
        return this.retryAuto;
    }

    public String getDatasetId() {
        return this.datasetId;
    }
}

