/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.campaign;

import com.chutneytesting.design.api.campaign.SchedulingCampaignDto;
import com.chutneytesting.design.domain.campaign.SchedulingCampaign;
import com.chutneytesting.design.domain.campaign.SchedulingCampaignRepository;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/v1/scheduling"})
@CrossOrigin(origins={"*"})
public class ScheduleCampaignController {
    private final SchedulingCampaignRepository schedulingCampaignRepository;

    public ScheduleCampaignController(SchedulingCampaignRepository schedulingCampaignRepository) {
        this.schedulingCampaignRepository = schedulingCampaignRepository;
    }

    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public List<SchedulingCampaignDto> getAll() {
        return this.schedulingCampaignRepository.getALl().stream().map(sc -> new SchedulingCampaignDto(sc.id, sc.campaignId, sc.campaignTitle, sc.schedulingDate)).sorted(Comparator.comparing(SchedulingCampaignDto::getSchedulingDate)).collect(Collectors.toList());
    }

    @PostMapping(path={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public void add(@RequestBody SchedulingCampaignDto dto) {
        this.schedulingCampaignRepository.add(new SchedulingCampaign(null, dto.getCampaignId(), dto.getCampaignTitle(), dto.getSchedulingDate()));
    }

    @DeleteMapping(path={"/{schedulingCampaignId}"}, produces={"application/json;charset=UTF-8"})
    public void delete(@PathVariable(value="schedulingCampaignId") Long schedulingCampaignId) {
        this.schedulingCampaignRepository.removeById(schedulingCampaignId);
    }
}

