/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.campaign;

import com.chutneytesting.design.api.campaign.dto.CampaignDto;
import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportDto;
import com.chutneytesting.design.api.campaign.dto.CampaignExecutionReportMapper;
import com.chutneytesting.design.api.campaign.dto.CampaignMapper;
import com.chutneytesting.design.api.scenario.v2_0.dto.TestCaseIndexDto;
import com.chutneytesting.design.domain.campaign.Campaign;
import com.chutneytesting.design.domain.campaign.CampaignExecutionReport;
import com.chutneytesting.design.domain.campaign.CampaignRepository;
import com.chutneytesting.design.domain.scenario.TestCaseRepository;
import com.chutneytesting.design.domain.scenario.compose.ComposableTestCaseRepository;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionEngine;
import com.chutneytesting.tools.ui.ComposableIdUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/v1"})
@CrossOrigin(origins={"*"})
public class CampaignController {
    private final TestCaseRepository testCaseRepository;
    private final ComposableTestCaseRepository composableTestCaseRepository;
    private final CampaignRepository campaignRepository;
    private final CampaignExecutionEngine campaignExecutionEngine;

    public CampaignController(TestCaseRepository testCaseRepository, ComposableTestCaseRepository composableTestCaseRepository, CampaignRepository campaignRepository, CampaignExecutionEngine campaignExecutionEngine) {
        this.testCaseRepository = testCaseRepository;
        this.composableTestCaseRepository = composableTestCaseRepository;
        this.campaignRepository = campaignRepository;
        this.campaignExecutionEngine = campaignExecutionEngine;
    }

    @PostMapping(path={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public CampaignDto saveCampaign(@RequestBody CampaignDto campaign) {
        return CampaignMapper.toDtoWithoutReport(this.campaignRepository.createOrUpdate(CampaignMapper.fromDto(campaign)));
    }

    @PutMapping(path={""}, consumes={"application/json;charset=UTF-8"}, produces={"application/json;charset=UTF-8"})
    public CampaignDto updateCampaign(@RequestBody CampaignDto campaign) {
        return CampaignMapper.toDtoWithoutReport(this.campaignRepository.createOrUpdate(CampaignMapper.fromDto(campaign)));
    }

    @DeleteMapping(path={"/{campaignId}"}, produces={"application/json;charset=UTF-8"})
    public boolean deleteCampaign(@PathVariable(value="campaignId") Long campaignId) {
        return this.campaignRepository.removeById(campaignId);
    }

    @GetMapping(path={"/{campaignId}"}, produces={"application/json;charset=UTF-8"})
    public CampaignDto getCampaignById(@PathVariable(value="campaignId") Long campaignId) {
        Campaign campaign = this.campaignRepository.findById(campaignId);
        List<CampaignExecutionReport> reports = this.campaignRepository.findExecutionsById(campaignId);
        if (!CollectionUtils.isEmpty(reports)) {
            reports.sort(CampaignExecutionReport.executionIdComparator().reversed());
        }
        this.campaignExecutionEngine.currentExecution(campaignId).ifPresent(report -> this.addCurrentExecution(reports, (CampaignExecutionReport)report));
        return CampaignMapper.toDto(campaign, reports);
    }

    @GetMapping(path={"/{campaignId}/scenarios"}, produces={"application/json;charset=UTF-8"})
    public List<TestCaseIndexDto> getCampaignScenarios(@PathVariable(value="campaignId") Long campaignId) {
        return this.campaignRepository.findScenariosIds(campaignId).stream().map(id -> {
            if (ComposableIdUtils.isComposableDomainId(id)) {
                return this.composableTestCaseRepository.findById((String)id).metadata();
            }
            return this.testCaseRepository.findMetadataById((String)id);
        }).map(meta -> TestCaseIndexDto.from(meta, Collections.emptyList())).collect(Collectors.toList());
    }

    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public List<CampaignDto> getAllCampaigns() {
        return this.campaignRepository.findAll().stream().map(CampaignMapper::toDtoWithoutReport).collect(Collectors.toList());
    }

    @GetMapping(path={"/lastexecutions/{limit}"}, produces={"application/json;charset=UTF-8"})
    public List<CampaignExecutionReportDto> getLastExecutions(@PathVariable(value="limit") Long limit) {
        List<CampaignExecutionReport> lastExecutions = this.campaignExecutionEngine.currentExecutions();
        if ((long)lastExecutions.size() < limit) {
            lastExecutions.addAll(this.campaignRepository.findLastExecutions(limit - (long)lastExecutions.size()));
        }
        return lastExecutions.stream().map(CampaignExecutionReportMapper::toDto).sorted(Comparator.comparing(value -> ((CampaignExecutionReportDto)value).getStartDate()).reversed()).collect(Collectors.toList());
    }

    @GetMapping(path={"/scenario/{scenarioId}"}, produces={"application/json;charset=UTF-8"})
    public List<CampaignDto> getCampaignsByScenarioId(@PathVariable(value="scenarioId") String scenarioId) {
        return this.campaignRepository.findCampaignsByScenarioId(ComposableIdUtils.fromFrontId(scenarioId)).stream().map(CampaignMapper::toDtoWithoutReport).collect(Collectors.toList());
    }

    private void addCurrentExecution(List<CampaignExecutionReport> currentCampaignExecutionReports, CampaignExecutionReport campaignExecutionReport) {
        if (currentCampaignExecutionReports == null) {
            currentCampaignExecutionReports = new ArrayList<CampaignExecutionReport>();
        }
        currentCampaignExecutionReports.add(0, campaignExecutionReport);
    }
}

