/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.infra.storage;

import com.chutneytesting.agent.domain.configure.LocalServerIdentifier;
import com.chutneytesting.agent.domain.explore.CurrentNetworkDescription;
import com.chutneytesting.agent.domain.network.Agent;
import com.chutneytesting.agent.domain.network.ImmutableNetworkDescription;
import com.chutneytesting.agent.domain.network.NetworkDescription;
import com.chutneytesting.agent.infra.storage.AgentNetworkForJsonFile;
import com.chutneytesting.agent.infra.storage.AgentNetworkMapperJsonFileMapper;
import com.chutneytesting.agent.infra.storage.JsonFileAgentNetworkDao;
import com.chutneytesting.environment.domain.EnvironmentRepository;
import java.io.OutputStream;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class JsonFileCurrentNetworkDescription
implements CurrentNetworkDescription {
    private final EnvironmentRepository environmentRepository;
    private final AgentNetworkMapperJsonFileMapper agentNetworkMapperJsonFileMapper;
    private final JsonFileAgentNetworkDao jsonFileAgentNetworkDao;
    private final LocalServerIdentifier localServerIdentifier;
    private Optional<NetworkDescription> networkDescription;

    public JsonFileCurrentNetworkDescription(EnvironmentRepository environmentRepository, AgentNetworkMapperJsonFileMapper agentNetworkMapperJsonFileMapper, JsonFileAgentNetworkDao jsonFileAgentNetworkDao, LocalServerIdentifier localServerIdentifier) {
        this.environmentRepository = environmentRepository;
        this.agentNetworkMapperJsonFileMapper = agentNetworkMapperJsonFileMapper;
        this.jsonFileAgentNetworkDao = jsonFileAgentNetworkDao;
        this.localServerIdentifier = localServerIdentifier;
        this.networkDescription = this.getNetworkDescription();
    }

    @Override
    public Optional<NetworkDescription> findCurrent() {
        this.networkDescription = this.getNetworkDescription();
        return this.networkDescription;
    }

    @Override
    public void switchTo(NetworkDescription networkDescription) {
        AgentNetworkForJsonFile dto = this.agentNetworkMapperJsonFileMapper.toDto(networkDescription);
        this.jsonFileAgentNetworkDao.save(dto);
    }

    @Override
    public void backup(OutputStream outputStream) {
        if (this.getNetworkDescription().isPresent()) {
            this.jsonFileAgentNetworkDao.backup(outputStream);
        }
    }

    private Optional<NetworkDescription> getNetworkDescription() {
        Optional<NetworkDescription> newNetworkDescription = this.jsonFileAgentNetworkDao.read().map(dto -> this.agentNetworkMapperJsonFileMapper.fromDto((AgentNetworkForJsonFile)dto, this.environmentRepository.getEnvironments()));
        if (newNetworkDescription.isPresent()) {
            Agent localAgent = this.localServerIdentifier.findLocalAgent(newNetworkDescription.get().agentGraph());
            newNetworkDescription = Optional.of(ImmutableNetworkDescription.builder().from(newNetworkDescription.get()).localAgent(localAgent).build());
        }
        return newNetworkDescription;
    }
}

