/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.infra.storage;

import com.chutneytesting.agent.infra.storage.AgentNetworkForJsonFile;
import com.chutneytesting.tools.ThrowingSupplier;
import com.chutneytesting.tools.ZipUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class JsonFileAgentNetworkDao {
    private final ObjectMapper objectMapper;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(false);
    private final File file;

    public JsonFileAgentNetworkDao(@Qualifier(value="agentNetworkPersistenceObjectMapper") ObjectMapper objectMapper, @Value(value="${persistence.agentNetwork.file:conf/endpoints.json}") File file) {
        this.objectMapper = objectMapper;
        this.file = file;
        file.delete();
    }

    public Optional<AgentNetworkForJsonFile> read() {
        return (Optional)this.executeWithLocking(this.rwLock.readLock(), () -> {
            if (!this.file.exists()) {
                return Optional.empty();
            }
            return Optional.of((AgentNetworkForJsonFile)this.objectMapper.readValue(this.file, AgentNetworkForJsonFile.class));
        });
    }

    public void save(AgentNetworkForJsonFile agentEndpointsConfiguration) {
        this.executeWithLocking(this.rwLock.writeLock(), () -> {
            Files.createParentDirs((File)this.file);
            this.objectMapper.writeValue(this.file, (Object)agentEndpointsConfiguration);
        });
    }

    public void backup(OutputStream outputStream) {
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            ZipUtils.compressFile(this.file, this.file.getName(), zipOutPut);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithLocking(Lock lock, ThrowingSupplier<T, ? extends Exception> supplier) {
        lock.lock();
        try {
            Object object = supplier.unsafeGet();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }
}

