/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.infra;

import com.chutneytesting.agent.api.dto.ExploreResultApiDto;
import com.chutneytesting.agent.api.mapper.AgentGraphApiMapper;
import com.chutneytesting.agent.api.mapper.AgentInfoApiMapper;
import com.chutneytesting.agent.api.mapper.EnvironmentApiMapper;
import com.chutneytesting.agent.api.mapper.ExploreResultApiMapper;
import com.chutneytesting.agent.api.mapper.NetworkConfigurationApiMapper;
import com.chutneytesting.agent.api.mapper.NetworkDescriptionApiMapper;
import com.chutneytesting.agent.domain.AgentClient;
import com.chutneytesting.agent.domain.configure.NetworkConfiguration;
import com.chutneytesting.agent.domain.explore.ExploreResult;
import com.chutneytesting.agent.domain.network.NetworkDescription;
import com.chutneytesting.engine.domain.delegation.ConnectionChecker;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
class HttpAgentClient
implements AgentClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAgentClient.class);
    private final RestTemplate restTemplate;
    private final ConnectionChecker connectionChecker;
    private final NetworkConfigurationApiMapper networkConfigurationApiMapper = new NetworkConfigurationApiMapper(new AgentInfoApiMapper(), new EnvironmentApiMapper());
    private final NetworkDescriptionApiMapper networkDescriptionApiMapper = new NetworkDescriptionApiMapper(new NetworkConfigurationApiMapper(new AgentInfoApiMapper(), new EnvironmentApiMapper()), new AgentGraphApiMapper(new AgentInfoApiMapper()));
    private final ExploreResultApiMapper exploreResultApiMapper = new ExploreResultApiMapper();

    HttpAgentClient(RestTemplate restTemplate, ConnectionChecker connectionChecker) throws UnknownHostException {
        this.restTemplate = restTemplate;
        this.connectionChecker = connectionChecker;
    }

    @Override
    public ExploreResult explore(String localName, NamedHostAndPort agentInfo, NetworkConfiguration networkConfiguration) {
        if (!this.connectionChecker.canConnectTo(agentInfo)) {
            return ExploreResult.EMPTY;
        }
        return this.exploreByHttp(localName, agentInfo, networkConfiguration);
    }

    @Override
    public void wrapUp(NamedHostAndPort agentInfo, NetworkDescription networkDescription) {
        if (this.connectionChecker.canConnectTo(agentInfo)) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)this.networkDescriptionApiMapper.toDto(networkDescription), (MultiValueMap)headers);
            this.restTemplate.postForObject("https://" + agentInfo.host() + ":" + agentInfo.port() + "/api/v1/agentnetwork/wrapup", (Object)request, Void.class, new Object[0]);
        }
    }

    private ExploreResult exploreByHttp(String localName, NamedHostAndPort agentInfo, NetworkConfiguration networkConfiguration) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)this.networkConfigurationApiMapper.toDto(networkConfiguration), (MultiValueMap)headers);
            ExploreResultApiDto response = (ExploreResultApiDto)this.restTemplate.postForObject("https://" + agentInfo.host() + ":" + agentInfo.port() + "/api/v1/agentnetwork/explore", (Object)request, ExploreResultApiDto.class, new Object[0]);
            return this.exploreResultApiMapper.fromDto(response, new ExploreResultApiDto.AgentLinkEntity(localName, agentInfo.name()));
        }
        catch (RestClientException e) {
            LOGGER.warn("Unable to propagate configure to reachable agent : " + agentInfo + " (" + e.getMessage() + ")");
            return ExploreResult.EMPTY;
        }
    }
}

