/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.domain.network;

import com.chutneytesting.agent.domain.configure.NetworkConfiguration;
import com.chutneytesting.agent.domain.network.Agent;
import com.chutneytesting.agent.domain.network.AgentGraph;
import com.chutneytesting.agent.domain.network.NetworkDescription;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableNetworkDescription
implements NetworkDescription {
    private final NetworkConfiguration configuration;
    private final AgentGraph agentGraph;
    @Nullable
    private final Agent localAgent;

    private ImmutableNetworkDescription(NetworkConfiguration configuration, AgentGraph agentGraph, @Nullable Agent localAgent) {
        this.configuration = configuration;
        this.agentGraph = agentGraph;
        this.localAgent = localAgent;
    }

    @Override
    public NetworkConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public AgentGraph agentGraph() {
        return this.agentGraph;
    }

    @Override
    public Optional<Agent> localAgent() {
        return Optional.ofNullable(this.localAgent);
    }

    public final ImmutableNetworkDescription withConfiguration(NetworkConfiguration value) {
        if (this.configuration == value) {
            return this;
        }
        NetworkConfiguration newValue = Objects.requireNonNull(value, "configuration");
        return new ImmutableNetworkDescription(newValue, this.agentGraph, this.localAgent);
    }

    public final ImmutableNetworkDescription withAgentGraph(AgentGraph value) {
        if (this.agentGraph == value) {
            return this;
        }
        AgentGraph newValue = Objects.requireNonNull(value, "agentGraph");
        return new ImmutableNetworkDescription(this.configuration, newValue, this.localAgent);
    }

    public final ImmutableNetworkDescription withLocalAgent(Agent value) {
        Agent newValue = Objects.requireNonNull(value, "localAgent");
        if (this.localAgent == newValue) {
            return this;
        }
        return new ImmutableNetworkDescription(this.configuration, this.agentGraph, newValue);
    }

    public final ImmutableNetworkDescription withLocalAgent(Optional<? extends Agent> optional) {
        Agent value = optional.orElse(null);
        if (this.localAgent == value) {
            return this;
        }
        return new ImmutableNetworkDescription(this.configuration, this.agentGraph, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkDescription && this.equalTo((ImmutableNetworkDescription)another);
    }

    private boolean equalTo(ImmutableNetworkDescription another) {
        return this.configuration.equals(another.configuration) && this.agentGraph.equals(another.agentGraph) && Objects.equals(this.localAgent, another.localAgent);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.configuration.hashCode();
        h += (h << 5) + this.agentGraph.hashCode();
        h += (h << 5) + Objects.hashCode(this.localAgent);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NetworkDescription").omitNullValues().add("configuration", (Object)this.configuration).add("agentGraph", (Object)this.agentGraph).add("localAgent", (Object)this.localAgent).toString();
    }

    public static ImmutableNetworkDescription copyOf(NetworkDescription instance) {
        if (instance instanceof ImmutableNetworkDescription) {
            return (ImmutableNetworkDescription)instance;
        }
        return ImmutableNetworkDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONFIGURATION = 1L;
        private static final long INIT_BIT_AGENT_GRAPH = 2L;
        private long initBits = 3L;
        @Nullable
        private NetworkConfiguration configuration;
        @Nullable
        private AgentGraph agentGraph;
        @Nullable
        private Agent localAgent;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NetworkDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.configuration(instance.configuration());
            this.agentGraph(instance.agentGraph());
            Optional<Agent> localAgentOptional = instance.localAgent();
            if (localAgentOptional.isPresent()) {
                this.localAgent(localAgentOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configuration(NetworkConfiguration configuration) {
            this.configuration = Objects.requireNonNull(configuration, "configuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder agentGraph(AgentGraph agentGraph) {
            this.agentGraph = Objects.requireNonNull(agentGraph, "agentGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder localAgent(Agent localAgent) {
            this.localAgent = Objects.requireNonNull(localAgent, "localAgent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder localAgent(Optional<? extends Agent> localAgent) {
            this.localAgent = localAgent.orElse(null);
            return this;
        }

        public ImmutableNetworkDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkDescription(this.configuration, this.agentGraph, this.localAgent);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("configuration");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("agentGraph");
            }
            return "Cannot build NetworkDescription, some of required attributes are not set " + attributes;
        }
    }
}

