/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.domain.explore;

import com.chutneytesting.agent.domain.TargetId;
import com.chutneytesting.agent.domain.explore.AgentId;
import com.chutneytesting.agent.domain.explore.ExploreResult;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableExploreResult
implements ExploreResult {
    private final ExploreResult.Links<AgentId, AgentId> agentLinks;
    private final ExploreResult.Links<AgentId, TargetId> targetLinks;

    private ImmutableExploreResult(ExploreResult.Links<AgentId, AgentId> agentLinks, ExploreResult.Links<AgentId, TargetId> targetLinks) {
        this.agentLinks = Objects.requireNonNull(agentLinks, "agentLinks");
        this.targetLinks = Objects.requireNonNull(targetLinks, "targetLinks");
    }

    private ImmutableExploreResult(ImmutableExploreResult original, ExploreResult.Links<AgentId, AgentId> agentLinks, ExploreResult.Links<AgentId, TargetId> targetLinks) {
        this.agentLinks = agentLinks;
        this.targetLinks = targetLinks;
    }

    @Override
    public ExploreResult.Links<AgentId, AgentId> agentLinks() {
        return this.agentLinks;
    }

    @Override
    public ExploreResult.Links<AgentId, TargetId> targetLinks() {
        return this.targetLinks;
    }

    public final ImmutableExploreResult withAgentLinks(ExploreResult.Links<AgentId, AgentId> value) {
        if (this.agentLinks == value) {
            return this;
        }
        ExploreResult.Links<AgentId, AgentId> newValue = Objects.requireNonNull(value, "agentLinks");
        return new ImmutableExploreResult(this, newValue, this.targetLinks);
    }

    public final ImmutableExploreResult withTargetLinks(ExploreResult.Links<AgentId, TargetId> value) {
        if (this.targetLinks == value) {
            return this;
        }
        ExploreResult.Links<AgentId, TargetId> newValue = Objects.requireNonNull(value, "targetLinks");
        return new ImmutableExploreResult(this, this.agentLinks, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExploreResult && this.equalTo((ImmutableExploreResult)another);
    }

    private boolean equalTo(ImmutableExploreResult another) {
        return this.agentLinks.equals(another.agentLinks) && this.targetLinks.equals(another.targetLinks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.agentLinks.hashCode();
        h += (h << 5) + this.targetLinks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExploreResult").omitNullValues().add("agentLinks", this.agentLinks).add("targetLinks", this.targetLinks).toString();
    }

    public static ImmutableExploreResult of(ExploreResult.Links<AgentId, AgentId> agentLinks, ExploreResult.Links<AgentId, TargetId> targetLinks) {
        return new ImmutableExploreResult(agentLinks, targetLinks);
    }

    public static ImmutableExploreResult copyOf(ExploreResult instance) {
        if (instance instanceof ImmutableExploreResult) {
            return (ImmutableExploreResult)instance;
        }
        return ImmutableExploreResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @CheckReturnValue
    @Immutable
    public static final class Links<SOURCE, DESTINATION>
    implements ExploreResult.Links<SOURCE, DESTINATION> {
        private final ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> links;

        private Links(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> links) {
            this.links = ImmutableSet.copyOf(links);
        }

        private Links(Links original, ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> links) {
            this.links = links;
        }

        @Override
        public ImmutableSet<ExploreResult.Link<SOURCE, DESTINATION>> links() {
            return this.links;
        }

        @SafeVarargs
        public final Links<SOURCE, DESTINATION> withLinks(ExploreResult.Link<SOURCE, DESTINATION> ... elements) {
            ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
            return new Links<SOURCE, DESTINATION>(this, newValue);
        }

        public final Links<SOURCE, DESTINATION> withLinks(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> elements) {
            if (this.links == elements) {
                return this;
            }
            ImmutableSet newValue = ImmutableSet.copyOf(elements);
            return new Links<SOURCE, DESTINATION>(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Links && this.equalTo((Links)another);
        }

        private boolean equalTo(Links<SOURCE, DESTINATION> another) {
            return this.links.equals(another.links);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.links.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Links").omitNullValues().add("links", this.links).toString();
        }

        public static <SOURCE, DESTINATION> Links<SOURCE, DESTINATION> of(Set<ExploreResult.Link<SOURCE, DESTINATION>> links) {
            return Links.of(links);
        }

        public static <SOURCE, DESTINATION> Links<SOURCE, DESTINATION> of(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> links) {
            return new Links<SOURCE, DESTINATION>(links);
        }

        public static <SOURCE, DESTINATION> Links<SOURCE, DESTINATION> copyOf(ExploreResult.Links<SOURCE, DESTINATION> instance) {
            if (instance instanceof Links) {
                return (Links)instance;
            }
            return Links.builder().from(instance).build();
        }

        public static <SOURCE, DESTINATION> Builder<SOURCE, DESTINATION> builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder<SOURCE, DESTINATION> {
            private ImmutableSet.Builder<ExploreResult.Link<SOURCE, DESTINATION>> links = ImmutableSet.builder();

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> from(ExploreResult.Links<SOURCE, DESTINATION> instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllLinks(instance.links());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> addLinks(ExploreResult.Link<SOURCE, DESTINATION> element) {
                this.links.add(element);
                return this;
            }

            @SafeVarargs
            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> addLinks(ExploreResult.Link<SOURCE, DESTINATION> ... elements) {
                this.links.add((Object[])elements);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> links(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> elements) {
                this.links = ImmutableSet.builder();
                return this.addAllLinks(elements);
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> addAllLinks(Iterable<? extends ExploreResult.Link<SOURCE, DESTINATION>> elements) {
                this.links.addAll(elements);
                return this;
            }

            public Links<SOURCE, DESTINATION> build() {
                return new Links(null, this.links.build());
            }
        }
    }

    @CheckReturnValue
    @Immutable
    public static final class Link<SOURCE, DESTINATION>
    implements ExploreResult.Link<SOURCE, DESTINATION> {
        private final SOURCE source;
        private final DESTINATION destination;

        private Link(SOURCE source, DESTINATION destination) {
            this.source = Objects.requireNonNull(source, "source");
            this.destination = Objects.requireNonNull(destination, "destination");
        }

        private Link(Link original, SOURCE source, DESTINATION destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public SOURCE source() {
            return this.source;
        }

        @Override
        public DESTINATION destination() {
            return this.destination;
        }

        public final Link<SOURCE, DESTINATION> withSource(SOURCE value) {
            if (this.source == value) {
                return this;
            }
            SOURCE newValue = Objects.requireNonNull(value, "source");
            return new Link<SOURCE, DESTINATION>(this, newValue, this.destination);
        }

        public final Link<SOURCE, DESTINATION> withDestination(DESTINATION value) {
            if (this.destination == value) {
                return this;
            }
            DESTINATION newValue = Objects.requireNonNull(value, "destination");
            return new Link<SOURCE, DESTINATION>(this, this.source, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Link && this.equalTo((Link)another);
        }

        private boolean equalTo(Link<SOURCE, DESTINATION> another) {
            return this.source.equals(another.source) && this.destination.equals(another.destination);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.source.hashCode();
            h += (h << 5) + this.destination.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Link").omitNullValues().add("source", this.source).add("destination", this.destination).toString();
        }

        public static <SOURCE, DESTINATION> Link<SOURCE, DESTINATION> of(SOURCE source, DESTINATION destination) {
            return new Link<SOURCE, DESTINATION>(source, destination);
        }

        public static <SOURCE, DESTINATION> Link<SOURCE, DESTINATION> copyOf(ExploreResult.Link<SOURCE, DESTINATION> instance) {
            if (instance instanceof Link) {
                return (Link)instance;
            }
            return Link.builder().from(instance).build();
        }

        public static <SOURCE, DESTINATION> Builder<SOURCE, DESTINATION> builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder<SOURCE, DESTINATION> {
            private static final long INIT_BIT_SOURCE = 1L;
            private static final long INIT_BIT_DESTINATION = 2L;
            private long initBits = 3L;
            @Nullable
            private SOURCE source;
            @Nullable
            private DESTINATION destination;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> from(ExploreResult.Link<SOURCE, DESTINATION> instance) {
                Objects.requireNonNull(instance, "instance");
                this.source(instance.source());
                this.destination(instance.destination());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> source(SOURCE source) {
                this.source = Objects.requireNonNull(source, "source");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<SOURCE, DESTINATION> destination(DESTINATION destination) {
                this.destination = Objects.requireNonNull(destination, "destination");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public Link<SOURCE, DESTINATION> build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Link<SOURCE, DESTINATION>(null, this.source, this.destination);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("source");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("destination");
                }
                return "Cannot build Link, some of required attributes are not set " + attributes;
            }
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AGENT_LINKS = 1L;
        private static final long INIT_BIT_TARGET_LINKS = 2L;
        private long initBits = 3L;
        @Nullable
        private ExploreResult.Links<AgentId, AgentId> agentLinks;
        @Nullable
        private ExploreResult.Links<AgentId, TargetId> targetLinks;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExploreResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.agentLinks(instance.agentLinks());
            this.targetLinks(instance.targetLinks());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder agentLinks(ExploreResult.Links<AgentId, AgentId> agentLinks) {
            this.agentLinks = Objects.requireNonNull(agentLinks, "agentLinks");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetLinks(ExploreResult.Links<AgentId, TargetId> targetLinks) {
            this.targetLinks = Objects.requireNonNull(targetLinks, "targetLinks");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExploreResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExploreResult(null, this.agentLinks, this.targetLinks);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("agentLinks");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetLinks");
            }
            return "Cannot build ExploreResult, some of required attributes are not set " + attributes;
        }
    }
}

