/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.api.mapper;

import com.chutneytesting.agent.api.dto.NetworkConfigurationApiDto;
import com.chutneytesting.environment.domain.Environment;
import com.chutneytesting.environment.domain.SecurityInfo;
import com.chutneytesting.environment.domain.Target;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentApiMapper {
    public Environment fromDto(NetworkConfigurationApiDto.EnvironmentApiDto environmentApiDto) {
        return Environment.builder().withName(environmentApiDto.name).withTargets(environmentApiDto.targetsConfiguration.stream().map(t -> this.fromDto((NetworkConfigurationApiDto.TargetsApiDto)t, environmentApiDto.name)).collect(Collectors.toSet())).build();
    }

    private Target fromDto(NetworkConfigurationApiDto.TargetsApiDto targetsApiDto, String env) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(targetsApiDto.properties);
        return Target.builder().withName(targetsApiDto.name).withEnvironment(env).withUrl(targetsApiDto.url).withProperties(properties).withSecurity(this.fromDto(targetsApiDto.security)).build();
    }

    private SecurityInfo fromDto(NetworkConfigurationApiDto.SecurityApiDto security) {
        SecurityInfo.SecurityInfoBuilder builder = SecurityInfo.builder();
        if (security.username != null || security.password != null) {
            builder.credential(SecurityInfo.Credential.of((String)Strings.nullToEmpty((String)security.username), (String)Strings.nullToEmpty((String)security.password)));
        }
        Optional.ofNullable(security.keyStore).ifPresent(k -> builder.keyStore(k));
        Optional.ofNullable(security.keyStorePassword).ifPresent(k -> builder.keyStorePassword(k));
        Optional.ofNullable(security.trustStore).ifPresent(k -> builder.trustStore(k));
        Optional.ofNullable(security.trustStorePassword).ifPresent(k -> builder.trustStorePassword(k));
        return builder.build();
    }

    public NetworkConfigurationApiDto.EnvironmentApiDto toDto(Environment environment) {
        return new NetworkConfigurationApiDto.EnvironmentApiDto(environment.name, environment.targets.stream().map(t -> this.toDto((Target)t)).collect(Collectors.toSet()));
    }

    private NetworkConfigurationApiDto.TargetsApiDto toDto(Target target) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(target.properties);
        return new NetworkConfigurationApiDto.TargetsApiDto(target.name, target.url, properties, this.toDto(target.security));
    }

    private NetworkConfigurationApiDto.SecurityApiDto toDto(SecurityInfo security) {
        String username = Optional.ofNullable(security.credential).map(c -> c.username).orElse(null);
        String password = Optional.ofNullable(security.credential).map(c -> c.password).orElse(null);
        String keyStore = Optional.ofNullable(security.keyStore).orElse(null);
        String keyStorePassword = Optional.ofNullable(security.keyStorePassword).orElse(null);
        String trustStore = Optional.ofNullable(security.trustStore).orElse(null);
        String trustStorePassword = Optional.ofNullable(security.trustStorePassword).orElse(null);
        return new NetworkConfigurationApiDto.SecurityApiDto(username, password, keyStore, keyStorePassword, trustStore, trustStorePassword);
    }
}

