/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent;

import com.chutneytesting.agent.domain.AgentClient;
import com.chutneytesting.agent.domain.configure.ConfigureService;
import com.chutneytesting.agent.domain.configure.Explorations;
import com.chutneytesting.agent.domain.configure.GetCurrentNetworkDescriptionService;
import com.chutneytesting.agent.domain.configure.LocalServerIdentifier;
import com.chutneytesting.agent.domain.explore.CurrentNetworkDescription;
import com.chutneytesting.agent.domain.explore.ExploreAgentsService;
import com.chutneytesting.engine.domain.delegation.ConnectionChecker;
import com.chutneytesting.environment.domain.EnvironmentRepository;
import com.chutneytesting.tools.ui.MyMixInForIgnoreType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class NodeNetworkSpringConfiguration {
    private static final String NODE_NETWORK_QUALIFIER = "agentnetwork";

    @Bean
    public ObjectMapper agentNetworkObjectMapper() {
        return new ObjectMapper().addMixIn(Resource.class, MyMixInForIgnoreType.class).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).findAndRegisterModules();
    }

    @Bean
    ObjectMapper agentNetworkPersistenceObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT);
        return objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    @Bean
    LocalServerIdentifier localServerIdentifier(@Value(value="${server.port:0}") int port, @Value(value="${localAgent.defaultName:#{null}}") Optional<String> defaultLocalName, @Value(value="${localAgent.defaultHostName:#{null}}") Optional<String> defaultLocalHostName) throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        return new LocalServerIdentifier(port, defaultLocalName.orElse(localHost.getHostName()), defaultLocalHostName.orElse(localHost.getCanonicalHostName()));
    }

    @Bean
    @Qualifier(value="agentnetwork")
    public RestTemplate restTemplateForHttpNodeNetwork(@Qualifier(value="agentNetworkObjectMapper") ObjectMapper nodeNetworkObjectMapper) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setMessageConverters((List)Lists.newArrayList((Object[])new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter(nodeNetworkObjectMapper)}));
        return restTemplate;
    }

    @Bean
    ExploreAgentsService agentNetwork(Explorations explorations, AgentClient agentClient, ConnectionChecker connectionChecker, LocalServerIdentifier localServerIdentifier) {
        return new ExploreAgentsService(explorations, agentClient, connectionChecker, localServerIdentifier);
    }

    @Bean
    ConfigureService configureService(ExploreAgentsService exploreAgentsService, CurrentNetworkDescription currentNetworkDescription, LocalServerIdentifier localServerIdentifier, EnvironmentRepository environmentRepository) {
        return new ConfigureService(exploreAgentsService, currentNetworkDescription, localServerIdentifier, environmentRepository);
    }

    @Bean
    GetCurrentNetworkDescriptionService getCurrentNetworkDescriptionService(CurrentNetworkDescription currentNetworkDescription) {
        return new GetCurrentNetworkDescriptionService(currentNetworkDescription);
    }
}

