/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.infra.storage;

import com.chutneytesting.admin.domain.HomePage;
import com.chutneytesting.admin.domain.HomePageRepository;
import com.chutneytesting.tools.ZipUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class JsonHomePageRepository
implements HomePageRepository {
    static final String HOME_PAGE_NAME = "home-page.json";
    private final Path homePageContent;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public JsonHomePageRepository(@Value(value="${persistence-repository-folder:conf/persistence}") String storeFolderPath) throws UncheckedIOException {
        try {
            Path dir = Paths.get(storeFolderPath, new String[0]).toAbsolutePath();
            Files.createDirectories(dir, new FileAttribute[0]);
            this.homePageContent = dir.resolve(HOME_PAGE_NAME);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HomePage load() {
        if (!Files.exists(this.homePageContent, new LinkOption[0])) {
            return new HomePage("NO CONTENT");
        }
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            HomePage homePage;
            block12: {
                InputStream is = Files.newInputStream(this.homePageContent, new OpenOption[0]);
                try {
                    homePage = (HomePage)this.objectMapper.readValue(is, HomePage.class);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                is.close();
            }
            return homePage;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public HomePage save(HomePage homePage) throws UncheckedIOException {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            HomePage homePage2;
            block11: {
                OutputStream os = Files.newOutputStream(this.homePageContent, new OpenOption[0]);
                try {
                    this.objectMapper.writeValue(os, (Object)homePage);
                    homePage2 = this.load();
                    if (os == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                os.close();
            }
            return homePage2;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void backup(OutputStream outputStream) {
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            ZipUtils.compressFile(this.homePageContent.toFile(), this.homePageContent.getFileName().toString(), zipOutPut);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

