/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.infra.storage;

import com.chutneytesting.design.infra.storage.scenario.git.GitRepository;
import com.chutneytesting.tools.file.FileUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class JsonFilesGitRepository {
    private final Path storeFolderPath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    JsonFilesGitRepository(@Value(value="${git-configuration-folder:git-conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).toAbsolutePath();
        this.initFolder();
    }

    public synchronized void save(GitRepository gitRepository) throws UnsupportedOperationException {
        Path gitRepositoryPath = this.getPath(gitRepository.id);
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)gitRepository);
            try {
                Files.write(gitRepositoryPath, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot save in configuration directory: " + this.storeFolderPath, e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + gitRepository, e);
        }
    }

    public Set<GitRepository> listGitRepository() {
        return (Set)FileUtils.doOnListFiles((Path)this.storeFolderPath, pathStream -> pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::isJsonFile).map(path -> {
            try {
                byte[] bytes = Files.readAllBytes(path);
                return (GitRepository)this.objectMapper.readValue(bytes, GitRepository.class);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize git-configuration file: " + path, e);
            }
        }).collect(Collectors.toSet()));
    }

    private boolean isJsonFile(Path path) {
        return path.getFileName().toString().endsWith(".json");
    }

    public void delete(Long gitRepositoryId) {
        Path gitRepositoryPath = this.getPath(gitRepositoryId);
        if (!Files.exists(gitRepositoryPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Git-configuration file not found: " + gitRepositoryPath);
        }
        try {
            Files.delete(gitRepositoryPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot delete git-configuration file: " + gitRepositoryPath, e);
        }
    }

    private void initFolder() throws UncheckedIOException {
        try {
            Files.createDirectories(this.storeFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create configuration directory: " + this.storeFolderPath, e);
        }
        Path testPath = this.storeFolderPath.resolve("test");
        if (!Files.exists(testPath, new LinkOption[0])) {
            try {
                Files.createFile(this.storeFolderPath.resolve("test"), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to initFolder in configuration directory: " + this.storeFolderPath, e);
            }
        }
        try {
            Files.delete(testPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to initFolder in configuration directory: " + this.storeFolderPath, e);
        }
    }

    private Path getPath(Long gitRepositoryId) {
        return this.storeFolderPath.resolve(gitRepositoryId + ".json");
    }
}

