/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.api;

import com.chutneytesting.admin.domain.DatabaseAdminService;
import com.chutneytesting.admin.domain.SqlResult;
import com.chutneytesting.tools.PaginatedDto;
import com.chutneytesting.tools.PaginationRequestWrapperDto;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/database"})
@CrossOrigin(origins={"*"})
public class DatabaseManagementController {
    private final DatabaseAdminService jdbcAdminService;
    private final DatabaseAdminService orientAdminService;

    DatabaseManagementController(DatabaseAdminService jdbcAdminService, DatabaseAdminService orientAdminService) {
        this.jdbcAdminService = jdbcAdminService;
        this.orientAdminService = orientAdminService;
    }

    @PostMapping(value={"/execute/orient"})
    public SqlResult executeOrient(@RequestBody String query) {
        return this.orientAdminService.execute(query);
    }

    @PostMapping(value={"/execute/jdbc"})
    public SqlResult executeh2(@RequestBody String query) {
        return this.jdbcAdminService.execute(query);
    }

    @PostMapping(value={"/paginate/orient"})
    public PaginatedDto<SqlResult> executeOrient(@RequestBody PaginationRequestWrapperDto<String> paginationRequestWrapperDto) {
        return this.orientAdminService.paginate(paginationRequestWrapperDto);
    }

    @PostMapping(value={"/paginate/jdbc"})
    public PaginatedDto<SqlResult> executeh2(@RequestBody PaginationRequestWrapperDto<String> paginationRequestWrapperDto) {
        return this.jdbcAdminService.paginate(paginationRequestWrapperDto);
    }
}

