/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.api;

import com.chutneytesting.admin.api.dto.BackupDto;
import com.chutneytesting.admin.api.dto.BackupMapper;
import com.chutneytesting.admin.domain.BackupRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/backups"})
@CrossOrigin(origins={"*"})
public class BackupController {
    private final BackupRepository backupRepository;

    public BackupController(BackupRepository backupRepository) {
        this.backupRepository = backupRepository;
    }

    @PostMapping(path={""}, consumes={"application/json;charset=UTF-8"})
    public String backup(@RequestBody BackupDto backupDto) {
        return this.backupRepository.save(BackupMapper.fromDto(backupDto));
    }

    @DeleteMapping(path={"/{backupId}"})
    public void delete(@PathVariable(value="backupId") String backupId) {
        this.backupRepository.delete(backupId);
    }

    @GetMapping(path={"/{backupId}"}, produces={"application/json;charset=UTF-8"})
    public BackupDto get(@PathVariable(value="backupId") String backupId) {
        return BackupMapper.toDto(this.backupRepository.read(backupId));
    }

    @GetMapping(path={"/{backupId}/download"}, produces={"application/zip"})
    public void getBackupData(HttpServletResponse response, @PathVariable(value="backupId") String backupId) throws IOException {
        this.backupRepository.getBackupData(backupId, (OutputStream)response.getOutputStream());
    }

    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public List<BackupDto> list() {
        return this.backupRepository.list().stream().map(BackupMapper::toDto).collect(Collectors.toList());
    }
}

