package com.chutneytesting.tools;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SortRequestParametersDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSortRequestParametersDto.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SortRequestParametersDto"})
@Immutable
@CheckReturnValue
public final class ImmutableSortRequestParametersDto
    implements SortRequestParametersDto {
  private final @Nullable String sort;
  private final @Nullable String desc;
  private final List<String> sortParameters;
  private final List<String> descParameters;

  private ImmutableSortRequestParametersDto(@Nullable String sort, @Nullable String desc) {
    this.sort = sort;
    this.desc = desc;
    this.sortParameters = initShim.sortParameters();
    this.descParameters = initShim.descParameters();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private List<String> sortParameters;
    private int sortParametersBuildStage;

    List<String> sortParameters() {
      if (sortParametersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sortParametersBuildStage == STAGE_UNINITIALIZED) {
        sortParametersBuildStage = STAGE_INITIALIZING;
        this.sortParameters = Objects.requireNonNull(sortParametersInitialize(), "sortParameters");
        sortParametersBuildStage = STAGE_INITIALIZED;
      }
      return this.sortParameters;
    }
    private List<String> descParameters;
    private int descParametersBuildStage;

    List<String> descParameters() {
      if (descParametersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (descParametersBuildStage == STAGE_UNINITIALIZED) {
        descParametersBuildStage = STAGE_INITIALIZING;
        this.descParameters = Objects.requireNonNull(descParametersInitialize(), "descParameters");
        descParametersBuildStage = STAGE_INITIALIZED;
      }
      return this.descParameters;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (sortParametersBuildStage == STAGE_INITIALIZING) attributes.add("sortParameters");
      if (descParametersBuildStage == STAGE_INITIALIZING) attributes.add("descParameters");
      return "Cannot build SortRequestParametersDto, attribute initializers form cycle" + attributes;
    }
  }

  private List<String> sortParametersInitialize() {
    return SortRequestParametersDto.super.sortParameters();
  }

  private List<String> descParametersInitialize() {
    return SortRequestParametersDto.super.descParameters();
  }

  /**
   * @return The value of the {@code sort} attribute
   */
  @JsonProperty("sort")
  @Override
  public @Nullable String sort() {
    return sort;
  }

  /**
   * @return The value of the {@code desc} attribute
   */
  @JsonProperty("desc")
  @Override
  public @Nullable String desc() {
    return desc;
  }

  /**
   * @return The computed-at-construction value of the {@code sortParameters} attribute
   */
  @JsonProperty("sortParameters")
  @Override
  public List<String> sortParameters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sortParameters()
        : this.sortParameters;
  }

  /**
   * @return The computed-at-construction value of the {@code descParameters} attribute
   */
  @JsonProperty("descParameters")
  @Override
  public List<String> descParameters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.descParameters()
        : this.descParameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortRequestParametersDto#sort() sort} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sort (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortRequestParametersDto withSort(@Nullable String value) {
    if (Objects.equals(this.sort, value)) return this;
    return new ImmutableSortRequestParametersDto(value, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SortRequestParametersDto#desc() desc} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for desc (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSortRequestParametersDto withDesc(@Nullable String value) {
    if (Objects.equals(this.desc, value)) return this;
    return new ImmutableSortRequestParametersDto(this.sort, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSortRequestParametersDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSortRequestParametersDto
        && equalTo((ImmutableSortRequestParametersDto) another);
  }

  private boolean equalTo(ImmutableSortRequestParametersDto another) {
    return Objects.equals(sort, another.sort)
        && Objects.equals(desc, another.desc)
        && sortParameters.equals(another.sortParameters)
        && descParameters.equals(another.descParameters);
  }

  /**
   * Computes a hash code from attributes: {@code sort}, {@code desc}, {@code sortParameters}, {@code descParameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(sort);
    h += (h << 5) + Objects.hashCode(desc);
    h += (h << 5) + sortParameters.hashCode();
    h += (h << 5) + descParameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SortRequestParametersDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SortRequestParametersDto{"
        + "sort=" + sort
        + ", desc=" + desc
        + ", sortParameters=" + sortParameters
        + ", descParameters=" + descParameters
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SortRequestParametersDto {
    @Nullable String sort;
    @Nullable String desc;
    @JsonProperty("sort")
    public void setSort(@Nullable String sort) {
      this.sort = sort;
    }
    @JsonProperty("desc")
    public void setDesc(@Nullable String desc) {
      this.desc = desc;
    }
    @Override
    public String sort() { throw new UnsupportedOperationException(); }
    @Override
    public String desc() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> sortParameters() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> descParameters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSortRequestParametersDto fromJson(Json json) {
    ImmutableSortRequestParametersDto.Builder builder = ImmutableSortRequestParametersDto.builder();
    if (json.sort != null) {
      builder.sort(json.sort);
    }
    if (json.desc != null) {
      builder.desc(json.desc);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SortRequestParametersDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SortRequestParametersDto instance
   */
  public static ImmutableSortRequestParametersDto copyOf(SortRequestParametersDto instance) {
    if (instance instanceof ImmutableSortRequestParametersDto) {
      return (ImmutableSortRequestParametersDto) instance;
    }
    return ImmutableSortRequestParametersDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSortRequestParametersDto ImmutableSortRequestParametersDto}.
   * @return A new ImmutableSortRequestParametersDto builder
   */
  public static ImmutableSortRequestParametersDto.Builder builder() {
    return new ImmutableSortRequestParametersDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSortRequestParametersDto ImmutableSortRequestParametersDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sort;
    private @Nullable String desc;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SortRequestParametersDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SortRequestParametersDto instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String sortValue = instance.sort();
      if (sortValue != null) {
        sort(sortValue);
      }
      @Nullable String descValue = instance.desc();
      if (descValue != null) {
        desc(descValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SortRequestParametersDto#sort() sort} attribute.
     * @param sort The value for sort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sort")
    public final Builder sort(@Nullable String sort) {
      this.sort = sort;
      return this;
    }

    /**
     * Initializes the value for the {@link SortRequestParametersDto#desc() desc} attribute.
     * @param desc The value for desc (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("desc")
    public final Builder desc(@Nullable String desc) {
      this.desc = desc;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSortRequestParametersDto ImmutableSortRequestParametersDto}.
     * @return An immutable instance of SortRequestParametersDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSortRequestParametersDto build() {
      return new ImmutableSortRequestParametersDto(sort, desc);
    }
  }
}
