package com.chutneytesting.tools;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PaginationRequestParametersDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePaginationRequestParametersDto.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PaginationRequestParametersDto"})
@Immutable
@CheckReturnValue
public final class ImmutablePaginationRequestParametersDto
    implements PaginationRequestParametersDto {
  private final Long start;
  private final Long limit;

  private ImmutablePaginationRequestParametersDto(ImmutablePaginationRequestParametersDto.Builder builder) {
    if (builder.start != null) {
      initShim.start(builder.start);
    }
    if (builder.limit != null) {
      initShim.limit(builder.limit);
    }
    this.start = initShim.start();
    this.limit = initShim.limit();
    this.initShim = null;
  }

  private ImmutablePaginationRequestParametersDto(Long start, Long limit) {
    this.start = start;
    this.limit = limit;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private Long start;
    private int startBuildStage;

    Long start() {
      if (startBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (startBuildStage == STAGE_UNINITIALIZED) {
        startBuildStage = STAGE_INITIALIZING;
        this.start = Objects.requireNonNull(startInitialize(), "start");
        startBuildStage = STAGE_INITIALIZED;
      }
      return this.start;
    }

    void start(Long start) {
      this.start = start;
      startBuildStage = STAGE_INITIALIZED;
    }
    private Long limit;
    private int limitBuildStage;

    Long limit() {
      if (limitBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (limitBuildStage == STAGE_UNINITIALIZED) {
        limitBuildStage = STAGE_INITIALIZING;
        this.limit = Objects.requireNonNull(limitInitialize(), "limit");
        limitBuildStage = STAGE_INITIALIZED;
      }
      return this.limit;
    }

    void limit(Long limit) {
      this.limit = limit;
      limitBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (startBuildStage == STAGE_INITIALIZING) attributes.add("start");
      if (limitBuildStage == STAGE_INITIALIZING) attributes.add("limit");
      return "Cannot build PaginationRequestParametersDto, attribute initializers form cycle" + attributes;
    }
  }

  private Long startInitialize() {
    return PaginationRequestParametersDto.super.start();
  }

  private Long limitInitialize() {
    return PaginationRequestParametersDto.super.limit();
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @JsonProperty("start")
  @Override
  public Long start() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.start()
        : this.start;
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @JsonProperty("limit")
  @Override
  public Long limit() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.limit()
        : this.limit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PaginationRequestParametersDto#start() start} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePaginationRequestParametersDto withStart(Long value) {
    if (this.start.equals(value)) return this;
    Long newValue = Objects.requireNonNull(value, "start");
    return new ImmutablePaginationRequestParametersDto(newValue, this.limit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PaginationRequestParametersDto#limit() limit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for limit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePaginationRequestParametersDto withLimit(Long value) {
    if (this.limit.equals(value)) return this;
    Long newValue = Objects.requireNonNull(value, "limit");
    return new ImmutablePaginationRequestParametersDto(this.start, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePaginationRequestParametersDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePaginationRequestParametersDto
        && equalTo((ImmutablePaginationRequestParametersDto) another);
  }

  private boolean equalTo(ImmutablePaginationRequestParametersDto another) {
    return start.equals(another.start)
        && limit.equals(another.limit);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + limit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PaginationRequestParametersDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PaginationRequestParametersDto{"
        + "start=" + start
        + ", limit=" + limit
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PaginationRequestParametersDto {
    @Nullable Long start;
    @Nullable Long limit;
    @JsonProperty("start")
    public void setStart(Long start) {
      this.start = start;
    }
    @JsonProperty("limit")
    public void setLimit(Long limit) {
      this.limit = limit;
    }
    @Override
    public Long start() { throw new UnsupportedOperationException(); }
    @Override
    public Long limit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePaginationRequestParametersDto fromJson(Json json) {
    ImmutablePaginationRequestParametersDto.Builder builder = ImmutablePaginationRequestParametersDto.builder();
    if (json.start != null) {
      builder.start(json.start);
    }
    if (json.limit != null) {
      builder.limit(json.limit);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PaginationRequestParametersDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PaginationRequestParametersDto instance
   */
  public static ImmutablePaginationRequestParametersDto copyOf(PaginationRequestParametersDto instance) {
    if (instance instanceof ImmutablePaginationRequestParametersDto) {
      return (ImmutablePaginationRequestParametersDto) instance;
    }
    return ImmutablePaginationRequestParametersDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePaginationRequestParametersDto ImmutablePaginationRequestParametersDto}.
   * @return A new ImmutablePaginationRequestParametersDto builder
   */
  public static ImmutablePaginationRequestParametersDto.Builder builder() {
    return new ImmutablePaginationRequestParametersDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePaginationRequestParametersDto ImmutablePaginationRequestParametersDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Long start;
    private @Nullable Long limit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PaginationRequestParametersDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PaginationRequestParametersDto instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      limit(instance.limit());
      return this;
    }

    /**
     * Initializes the value for the {@link PaginationRequestParametersDto#start() start} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PaginationRequestParametersDto#start() start}.</em>
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("start")
    public final Builder start(Long start) {
      this.start = Objects.requireNonNull(start, "start");
      return this;
    }

    /**
     * Initializes the value for the {@link PaginationRequestParametersDto#limit() limit} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PaginationRequestParametersDto#limit() limit}.</em>
     * @param limit The value for limit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("limit")
    public final Builder limit(Long limit) {
      this.limit = Objects.requireNonNull(limit, "limit");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePaginationRequestParametersDto ImmutablePaginationRequestParametersDto}.
     * @return An immutable instance of PaginationRequestParametersDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePaginationRequestParametersDto build() {
      return new ImmutablePaginationRequestParametersDto(this);
    }
  }
}
