package com.chutneytesting.execution.domain.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link RunningScenarioState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRunningScenarioState.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRunningScenarioState.of()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "RunningScenarioState"})
@Immutable
@CheckReturnValue
public final class ImmutableRunningScenarioState
    implements RunningScenarioState {
  private final String scenarioId;
  private final Instant startTime;

  private ImmutableRunningScenarioState(String scenarioId) {
    this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
    this.startTime = Objects.requireNonNull(RunningScenarioState.super.startTime(), "startTime");
  }

  private ImmutableRunningScenarioState(ImmutableRunningScenarioState original, String scenarioId) {
    this.scenarioId = scenarioId;
    this.startTime = Objects.requireNonNull(RunningScenarioState.super.startTime(), "startTime");
  }

  /**
   * @return The value of the {@code scenarioId} attribute
   */
  @Override
  public String scenarioId() {
    return scenarioId;
  }

  /**
   * @return The computed-at-construction value of the {@code startTime} attribute
   */
  @Override
  public Instant startTime() {
    return startTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RunningScenarioState#scenarioId() scenarioId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scenarioId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRunningScenarioState withScenarioId(String value) {
    if (this.scenarioId.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "scenarioId");
    return new ImmutableRunningScenarioState(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRunningScenarioState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRunningScenarioState
        && equalTo((ImmutableRunningScenarioState) another);
  }

  private boolean equalTo(ImmutableRunningScenarioState another) {
    return scenarioId.equals(another.scenarioId)
        && startTime.equals(another.startTime);
  }

  /**
   * Computes a hash code from attributes: {@code scenarioId}, {@code startTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + scenarioId.hashCode();
    h += (h << 5) + startTime.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RunningScenarioState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RunningScenarioState")
        .omitNullValues()
        .add("scenarioId", scenarioId)
        .add("startTime", startTime)
        .toString();
  }

  /**
   * Construct a new immutable {@code RunningScenarioState} instance.
   * @param scenarioId The value for the {@code scenarioId} attribute
   * @return An immutable RunningScenarioState instance
   */
  public static ImmutableRunningScenarioState of(String scenarioId) {
    return new ImmutableRunningScenarioState(scenarioId);
  }

  /**
   * Creates an immutable copy of a {@link RunningScenarioState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RunningScenarioState instance
   */
  public static ImmutableRunningScenarioState copyOf(RunningScenarioState instance) {
    if (instance instanceof ImmutableRunningScenarioState) {
      return (ImmutableRunningScenarioState) instance;
    }
    return ImmutableRunningScenarioState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRunningScenarioState ImmutableRunningScenarioState}.
   * @return A new ImmutableRunningScenarioState builder
   */
  public static ImmutableRunningScenarioState.Builder builder() {
    return new ImmutableRunningScenarioState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRunningScenarioState ImmutableRunningScenarioState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCENARIO_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String scenarioId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RunningScenarioState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RunningScenarioState instance) {
      Objects.requireNonNull(instance, "instance");
      scenarioId(instance.scenarioId());
      return this;
    }

    /**
     * Initializes the value for the {@link RunningScenarioState#scenarioId() scenarioId} attribute.
     * @param scenarioId The value for scenarioId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder scenarioId(String scenarioId) {
      this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
      initBits &= ~INIT_BIT_SCENARIO_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRunningScenarioState ImmutableRunningScenarioState}.
     * @return An immutable instance of RunningScenarioState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRunningScenarioState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRunningScenarioState(null, scenarioId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_SCENARIO_ID) != 0) attributes.add("scenarioId");
      return "Cannot build RunningScenarioState, some of required attributes are not set " + attributes;
    }
  }
}
