package com.chutneytesting.execution.domain.history;

import com.chutneytesting.execution.domain.report.ServerReportStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ExecutionHistory}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecutionHistory.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableExecutionHistory.of()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ExecutionHistory"})
@Immutable
@CheckReturnValue
public final class ImmutableExecutionHistory
    implements ExecutionHistory {
  private final String scenarioId;
  private final ImmutableList<ExecutionHistory.Execution> history;

  private ImmutableExecutionHistory(
      String scenarioId,
      Iterable<? extends ExecutionHistory.Execution> history) {
    this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
    this.history = ImmutableList.copyOf(history);
  }

  private ImmutableExecutionHistory(
      ImmutableExecutionHistory original,
      String scenarioId,
      ImmutableList<ExecutionHistory.Execution> history) {
    this.scenarioId = scenarioId;
    this.history = history;
  }

  /**
   * @return The value of the {@code scenarioId} attribute
   */
  @JsonProperty("scenarioId")
  @Override
  public String scenarioId() {
    return scenarioId;
  }

  /**
   * @return The value of the {@code history} attribute
   */
  @JsonProperty("history")
  @Override
  public ImmutableList<ExecutionHistory.Execution> history() {
    return history;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionHistory#scenarioId() scenarioId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scenarioId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionHistory withScenarioId(String value) {
    if (this.scenarioId.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "scenarioId");
    return new ImmutableExecutionHistory(this, newValue, this.history);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExecutionHistory#history() history}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionHistory withHistory(ExecutionHistory.Execution... elements) {
    ImmutableList<ExecutionHistory.Execution> newValue = ImmutableList.copyOf(elements);
    return new ImmutableExecutionHistory(this, this.scenarioId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExecutionHistory#history() history}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of history elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionHistory withHistory(Iterable<? extends ExecutionHistory.Execution> elements) {
    if (this.history == elements) return this;
    ImmutableList<ExecutionHistory.Execution> newValue = ImmutableList.copyOf(elements);
    return new ImmutableExecutionHistory(this, this.scenarioId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecutionHistory} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecutionHistory
        && equalTo((ImmutableExecutionHistory) another);
  }

  private boolean equalTo(ImmutableExecutionHistory another) {
    return scenarioId.equals(another.scenarioId)
        && history.equals(another.history);
  }

  /**
   * Computes a hash code from attributes: {@code scenarioId}, {@code history}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + scenarioId.hashCode();
    h += (h << 5) + history.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExecutionHistory} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExecutionHistory")
        .omitNullValues()
        .add("scenarioId", scenarioId)
        .add("history", history)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ExecutionHistory {
    @Nullable String scenarioId;
    @Nullable List<ExecutionHistory.Execution> history = ImmutableList.of();
    @JsonProperty("scenarioId")
    public void setScenarioId(String scenarioId) {
      this.scenarioId = scenarioId;
    }
    @JsonProperty("history")
    public void setHistory(List<ExecutionHistory.Execution> history) {
      this.history = history;
    }
    @Override
    public String scenarioId() { throw new UnsupportedOperationException(); }
    @Override
    public List<ExecutionHistory.Execution> history() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableExecutionHistory fromJson(Json json) {
    ImmutableExecutionHistory.Builder builder = ImmutableExecutionHistory.builder();
    if (json.scenarioId != null) {
      builder.scenarioId(json.scenarioId);
    }
    if (json.history != null) {
      builder.addAllHistory(json.history);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ExecutionHistory} instance.
   * @param scenarioId The value for the {@code scenarioId} attribute
   * @param history The value for the {@code history} attribute
   * @return An immutable ExecutionHistory instance
   */
  public static ImmutableExecutionHistory of(String scenarioId, List<ExecutionHistory.Execution> history) {
    return of(scenarioId, (Iterable<? extends ExecutionHistory.Execution>) history);
  }

  /**
   * Construct a new immutable {@code ExecutionHistory} instance.
   * @param scenarioId The value for the {@code scenarioId} attribute
   * @param history The value for the {@code history} attribute
   * @return An immutable ExecutionHistory instance
   */
  public static ImmutableExecutionHistory of(String scenarioId, Iterable<? extends ExecutionHistory.Execution> history) {
    return new ImmutableExecutionHistory(scenarioId, history);
  }

  /**
   * Creates an immutable copy of a {@link ExecutionHistory} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecutionHistory instance
   */
  public static ImmutableExecutionHistory copyOf(ExecutionHistory instance) {
    if (instance instanceof ImmutableExecutionHistory) {
      return (ImmutableExecutionHistory) instance;
    }
    return ImmutableExecutionHistory.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecutionHistory ImmutableExecutionHistory}.
   * @return A new ImmutableExecutionHistory builder
   */
  public static ImmutableExecutionHistory.Builder builder() {
    return new ImmutableExecutionHistory.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecutionHistory ImmutableExecutionHistory}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCENARIO_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String scenarioId;
    private ImmutableList.Builder<ExecutionHistory.Execution> history = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExecutionHistory} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExecutionHistory instance) {
      Objects.requireNonNull(instance, "instance");
      scenarioId(instance.scenarioId());
      addAllHistory(instance.history());
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionHistory#scenarioId() scenarioId} attribute.
     * @param scenarioId The value for scenarioId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder scenarioId(String scenarioId) {
      this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
      initBits &= ~INIT_BIT_SCENARIO_ID;
      return this;
    }

    /**
     * Adds one element to {@link ExecutionHistory#history() history} list.
     * @param element A history element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHistory(ExecutionHistory.Execution element) {
      this.history.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExecutionHistory#history() history} list.
     * @param elements An array of history elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHistory(ExecutionHistory.Execution... elements) {
      this.history.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ExecutionHistory#history() history} list.
     * @param elements An iterable of history elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder history(Iterable<? extends ExecutionHistory.Execution> elements) {
      this.history = ImmutableList.builder();
      return addAllHistory(elements);
    }

    /**
     * Adds elements to {@link ExecutionHistory#history() history} list.
     * @param elements An iterable of history elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllHistory(Iterable<? extends ExecutionHistory.Execution> elements) {
      this.history.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecutionHistory ImmutableExecutionHistory}.
     * @return An immutable instance of ExecutionHistory
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecutionHistory build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecutionHistory(null, scenarioId, history.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_SCENARIO_ID) != 0) attributes.add("scenarioId");
      return "Cannot build ExecutionHistory, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link ExecutionHistory.Execution}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableExecutionHistory.Execution.builder()}.
   */
  @Immutable
  @CheckReturnValue
  public static final class Execution
      implements ExecutionHistory.Execution {
    private final LocalDateTime time;
    private final long duration;
    private final ServerReportStatus status;
    private final @Nullable String info;
    private final @Nullable String error;
    private final String testCaseTitle;
    private final String environment;
    private final @Nullable String datasetId;
    private final @Nullable Integer datasetVersion;
    private final String user;
    private final String report;
    private final Long executionId;

    private Execution(
        LocalDateTime time,
        long duration,
        ServerReportStatus status,
        @Nullable String info,
        @Nullable String error,
        String testCaseTitle,
        String environment,
        @Nullable String datasetId,
        @Nullable Integer datasetVersion,
        String user,
        String report,
        Long executionId) {
      this.time = time;
      this.duration = duration;
      this.status = status;
      this.info = info;
      this.error = error;
      this.testCaseTitle = testCaseTitle;
      this.environment = environment;
      this.datasetId = datasetId;
      this.datasetVersion = datasetVersion;
      this.user = user;
      this.report = report;
      this.executionId = executionId;
    }

    /**
     * @return The value of the {@code time} attribute
     */
    @JsonProperty("time")
    @Override
    public LocalDateTime time() {
      return time;
    }

    /**
     * @return The value of the {@code duration} attribute
     */
    @JsonProperty("duration")
    @Override
    public long duration() {
      return duration;
    }

    /**
     * @return The value of the {@code status} attribute
     */
    @JsonProperty("status")
    @Override
    public ServerReportStatus status() {
      return status;
    }

    /**
     * @return The value of the {@code info} attribute
     */
    @JsonProperty("info")
    @Override
    public Optional<String> info() {
      return Optional.ofNullable(info);
    }

    /**
     * @return The value of the {@code error} attribute
     */
    @JsonProperty("error")
    @Override
    public Optional<String> error() {
      return Optional.ofNullable(error);
    }

    /**
     * @return The value of the {@code testCaseTitle} attribute
     */
    @JsonProperty("testCaseTitle")
    @Override
    public String testCaseTitle() {
      return testCaseTitle;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @JsonProperty("environment")
    @Override
    public String environment() {
      return environment;
    }

    /**
     * @return The value of the {@code datasetId} attribute
     */
    @JsonProperty("datasetId")
    @Override
    public Optional<String> datasetId() {
      return Optional.ofNullable(datasetId);
    }

    /**
     * @return The value of the {@code datasetVersion} attribute
     */
    @JsonProperty("datasetVersion")
    @Override
    public Optional<Integer> datasetVersion() {
      return Optional.ofNullable(datasetVersion);
    }

    /**
     * @return The value of the {@code user} attribute
     */
    @JsonProperty("user")
    @Override
    public String user() {
      return user;
    }

    /**
     * @return The value of the {@code report} attribute
     */
    @JsonProperty("report")
    @Override
    public String report() {
      return report;
    }

    /**
     * @return The value of the {@code executionId} attribute
     */
    @JsonProperty("executionId")
    @Override
    public Long executionId() {
      return executionId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#time() time} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for time
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withTime(LocalDateTime value) {
      if (this.time == value) return this;
      LocalDateTime newValue = Objects.requireNonNull(value, "time");
      return new ImmutableExecutionHistory.Execution(
          newValue,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#duration() duration} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for duration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withDuration(long value) {
      if (this.duration == value) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          value,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#status() status} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for status
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withStatus(ServerReportStatus value) {
      if (this.status == value) return this;
      ServerReportStatus newValue = Objects.requireNonNull(value, "status");
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          newValue,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.Execution#info() info} attribute.
     * @param value The value for info
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withInfo(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "info");
      if (Objects.equals(this.info, newValue)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          newValue,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.Execution#info() info} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for info
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withInfo(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.info, value)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          value,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.Execution#error() error} attribute.
     * @param value The value for error
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withError(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "error");
      if (Objects.equals(this.error, newValue)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          newValue,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.Execution#error() error} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for error
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withError(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.error, value)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          value,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#testCaseTitle() testCaseTitle} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for testCaseTitle
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withTestCaseTitle(String value) {
      if (this.testCaseTitle.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "testCaseTitle");
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          newValue,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#environment() environment} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withEnvironment(String value) {
      if (this.environment.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "environment");
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          newValue,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.Execution#datasetId() datasetId} attribute.
     * @param value The value for datasetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withDatasetId(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "datasetId");
      if (Objects.equals(this.datasetId, newValue)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          newValue,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.Execution#datasetId() datasetId} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for datasetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withDatasetId(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.datasetId, value)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          value,
          this.datasetVersion,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.Execution#datasetVersion() datasetVersion} attribute.
     * @param value The value for datasetVersion
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withDatasetVersion(int value) {
      @Nullable Integer newValue = value;
      if (Objects.equals(this.datasetVersion, newValue)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          newValue,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.Execution#datasetVersion() datasetVersion} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for datasetVersion
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withDatasetVersion(Optional<Integer> optional) {
      @Nullable Integer value = optional.orElse(null);
      if (Objects.equals(this.datasetVersion, value)) return this;
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          value,
          this.user,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#user() user} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for user
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withUser(String value) {
      if (this.user.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "user");
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          newValue,
          this.report,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#report() report} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for report
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withReport(String value) {
      if (this.report.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "report");
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          newValue,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.Execution#executionId() executionId} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for executionId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.Execution withExecutionId(Long value) {
      if (this.executionId.equals(value)) return this;
      Long newValue = Objects.requireNonNull(value, "executionId");
      return new ImmutableExecutionHistory.Execution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report,
          newValue);
    }

    /**
     * This instance is equal to all instances of {@code Execution} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableExecutionHistory.Execution
          && equalTo((ImmutableExecutionHistory.Execution) another);
    }

    private boolean equalTo(ImmutableExecutionHistory.Execution another) {
      return time.equals(another.time)
          && duration == another.duration
          && status.equals(another.status)
          && Objects.equals(info, another.info)
          && Objects.equals(error, another.error)
          && testCaseTitle.equals(another.testCaseTitle)
          && environment.equals(another.environment)
          && Objects.equals(datasetId, another.datasetId)
          && Objects.equals(datasetVersion, another.datasetVersion)
          && user.equals(another.user)
          && report.equals(another.report)
          && executionId.equals(another.executionId);
    }

    /**
     * Computes a hash code from attributes: {@code time}, {@code duration}, {@code status}, {@code info}, {@code error}, {@code testCaseTitle}, {@code environment}, {@code datasetId}, {@code datasetVersion}, {@code user}, {@code report}, {@code executionId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + time.hashCode();
      h += (h << 5) + Longs.hashCode(duration);
      h += (h << 5) + status.hashCode();
      h += (h << 5) + Objects.hashCode(info);
      h += (h << 5) + Objects.hashCode(error);
      h += (h << 5) + testCaseTitle.hashCode();
      h += (h << 5) + environment.hashCode();
      h += (h << 5) + Objects.hashCode(datasetId);
      h += (h << 5) + Objects.hashCode(datasetVersion);
      h += (h << 5) + user.hashCode();
      h += (h << 5) + report.hashCode();
      h += (h << 5) + executionId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Execution} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Execution")
          .omitNullValues()
          .add("time", time)
          .add("duration", duration)
          .add("status", status)
          .add("info", info)
          .add("error", error)
          .add("testCaseTitle", testCaseTitle)
          .add("environment", environment)
          .add("datasetId", datasetId)
          .add("datasetVersion", datasetVersion)
          .add("user", user)
          .add("report", report)
          .add("executionId", executionId)
          .toString();
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements ExecutionHistory.Execution {
      @Nullable LocalDateTime time;
      long duration;
      boolean durationIsSet;
      @Nullable ServerReportStatus status;
      @Nullable Optional<String> info = Optional.empty();
      @Nullable Optional<String> error = Optional.empty();
      @Nullable String testCaseTitle;
      @Nullable String environment;
      @Nullable Optional<String> datasetId = Optional.empty();
      @Nullable Optional<Integer> datasetVersion = Optional.empty();
      @Nullable String user;
      @Nullable String report;
      @Nullable Long executionId;
      @JsonProperty("time")
      public void setTime(LocalDateTime time) {
        this.time = time;
      }
      @JsonProperty("duration")
      public void setDuration(long duration) {
        this.duration = duration;
        this.durationIsSet = true;
      }
      @JsonProperty("status")
      public void setStatus(ServerReportStatus status) {
        this.status = status;
      }
      @JsonProperty("info")
      public void setInfo(Optional<String> info) {
        this.info = info;
      }
      @JsonProperty("error")
      public void setError(Optional<String> error) {
        this.error = error;
      }
      @JsonProperty("testCaseTitle")
      public void setTestCaseTitle(String testCaseTitle) {
        this.testCaseTitle = testCaseTitle;
      }
      @JsonProperty("environment")
      public void setEnvironment(String environment) {
        this.environment = environment;
      }
      @JsonProperty("datasetId")
      public void setDatasetId(Optional<String> datasetId) {
        this.datasetId = datasetId;
      }
      @JsonProperty("datasetVersion")
      public void setDatasetVersion(Optional<Integer> datasetVersion) {
        this.datasetVersion = datasetVersion;
      }
      @JsonProperty("user")
      public void setUser(String user) {
        this.user = user;
      }
      @JsonProperty("report")
      public void setReport(String report) {
        this.report = report;
      }
      @JsonProperty("executionId")
      public void setExecutionId(Long executionId) {
        this.executionId = executionId;
      }
      @Override
      public LocalDateTime time() { throw new UnsupportedOperationException(); }
      @Override
      public long duration() { throw new UnsupportedOperationException(); }
      @Override
      public ServerReportStatus status() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> info() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> error() { throw new UnsupportedOperationException(); }
      @Override
      public String testCaseTitle() { throw new UnsupportedOperationException(); }
      @Override
      public String environment() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> datasetId() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<Integer> datasetVersion() { throw new UnsupportedOperationException(); }
      @Override
      public String user() { throw new UnsupportedOperationException(); }
      @Override
      public String report() { throw new UnsupportedOperationException(); }
      @Override
      public Long executionId() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableExecutionHistory.Execution fromJson(Json json) {
      ImmutableExecutionHistory.Execution.Builder builder = ImmutableExecutionHistory.Execution.builder();
      if (json.time != null) {
        builder.time(json.time);
      }
      if (json.durationIsSet) {
        builder.duration(json.duration);
      }
      if (json.status != null) {
        builder.status(json.status);
      }
      if (json.info != null) {
        builder.info(json.info);
      }
      if (json.error != null) {
        builder.error(json.error);
      }
      if (json.testCaseTitle != null) {
        builder.testCaseTitle(json.testCaseTitle);
      }
      if (json.environment != null) {
        builder.environment(json.environment);
      }
      if (json.datasetId != null) {
        builder.datasetId(json.datasetId);
      }
      if (json.datasetVersion != null) {
        builder.datasetVersion(json.datasetVersion);
      }
      if (json.user != null) {
        builder.user(json.user);
      }
      if (json.report != null) {
        builder.report(json.report);
      }
      if (json.executionId != null) {
        builder.executionId(json.executionId);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link ExecutionHistory.Execution} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Execution instance
     */
    public static ImmutableExecutionHistory.Execution copyOf(ExecutionHistory.Execution instance) {
      if (instance instanceof ImmutableExecutionHistory.Execution) {
        return (ImmutableExecutionHistory.Execution) instance;
      }
      return ImmutableExecutionHistory.Execution.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableExecutionHistory.Execution Execution}.
     * @return A new Execution builder
     */
    public static ImmutableExecutionHistory.Execution.Builder builder() {
      return new ImmutableExecutionHistory.Execution.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableExecutionHistory.Execution Execution}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TIME = 0x1L;
      private static final long INIT_BIT_DURATION = 0x2L;
      private static final long INIT_BIT_STATUS = 0x4L;
      private static final long INIT_BIT_TEST_CASE_TITLE = 0x8L;
      private static final long INIT_BIT_ENVIRONMENT = 0x10L;
      private static final long INIT_BIT_USER = 0x20L;
      private static final long INIT_BIT_REPORT = 0x40L;
      private static final long INIT_BIT_EXECUTION_ID = 0x80L;
      private long initBits = 0xffL;

      private @Nullable LocalDateTime time;
      private long duration;
      private @Nullable ServerReportStatus status;
      private @Nullable String info;
      private @Nullable String error;
      private @Nullable String testCaseTitle;
      private @Nullable String environment;
      private @Nullable String datasetId;
      private @Nullable Integer datasetVersion;
      private @Nullable String user;
      private @Nullable String report;
      private @Nullable Long executionId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.Attached} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.Attached instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.ExecutionProperties} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.ExecutionProperties instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.HavingReport} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(HavingReport instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.Execution} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.Execution instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof ExecutionHistory.Attached) {
          ExecutionHistory.Attached instance = (ExecutionHistory.Attached) object;
          executionId(instance.executionId());
        }
        if (object instanceof ExecutionHistory.ExecutionProperties) {
          ExecutionHistory.ExecutionProperties instance = (ExecutionHistory.ExecutionProperties) object;
          duration(instance.duration());
          environment(instance.environment());
          Optional<Integer> datasetVersionOptional = instance.datasetVersion();
          if (datasetVersionOptional.isPresent()) {
            datasetVersion(datasetVersionOptional);
          }
          Optional<String> datasetIdOptional = instance.datasetId();
          if (datasetIdOptional.isPresent()) {
            datasetId(datasetIdOptional);
          }
          time(instance.time());
          Optional<String> errorOptional = instance.error();
          if (errorOptional.isPresent()) {
            error(errorOptional);
          }
          testCaseTitle(instance.testCaseTitle());
          user(instance.user());
          status(instance.status());
          Optional<String> infoOptional = instance.info();
          if (infoOptional.isPresent()) {
            info(infoOptional);
          }
        }
        if (object instanceof HavingReport) {
          HavingReport instance = (HavingReport) object;
          report(instance.report());
        }
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#time() time} attribute.
       * @param time The value for time 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder time(LocalDateTime time) {
        this.time = Objects.requireNonNull(time, "time");
        initBits &= ~INIT_BIT_TIME;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#duration() duration} attribute.
       * @param duration The value for duration 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder duration(long duration) {
        this.duration = duration;
        initBits &= ~INIT_BIT_DURATION;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#status() status} attribute.
       * @param status The value for status 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder status(ServerReportStatus status) {
        this.status = Objects.requireNonNull(status, "status");
        initBits &= ~INIT_BIT_STATUS;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#info() info} to info.
       * @param info The value for info
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder info(String info) {
        this.info = Objects.requireNonNull(info, "info");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#info() info} to info.
       * @param info The value for info
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder info(Optional<String> info) {
        this.info = info.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#error() error} to error.
       * @param error The value for error
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder error(String error) {
        this.error = Objects.requireNonNull(error, "error");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#error() error} to error.
       * @param error The value for error
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder error(Optional<String> error) {
        this.error = error.orElse(null);
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#testCaseTitle() testCaseTitle} attribute.
       * @param testCaseTitle The value for testCaseTitle 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder testCaseTitle(String testCaseTitle) {
        this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
        initBits &= ~INIT_BIT_TEST_CASE_TITLE;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#environment() environment} attribute.
       * @param environment The value for environment 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder environment(String environment) {
        this.environment = Objects.requireNonNull(environment, "environment");
        initBits &= ~INIT_BIT_ENVIRONMENT;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#datasetId() datasetId} to datasetId.
       * @param datasetId The value for datasetId
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetId(String datasetId) {
        this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#datasetId() datasetId} to datasetId.
       * @param datasetId The value for datasetId
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetId(Optional<String> datasetId) {
        this.datasetId = datasetId.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#datasetVersion() datasetVersion} to datasetVersion.
       * @param datasetVersion The value for datasetVersion
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetVersion(int datasetVersion) {
        this.datasetVersion = datasetVersion;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.Execution#datasetVersion() datasetVersion} to datasetVersion.
       * @param datasetVersion The value for datasetVersion
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetVersion(Optional<Integer> datasetVersion) {
        this.datasetVersion = datasetVersion.orElse(null);
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#user() user} attribute.
       * @param user The value for user 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder user(String user) {
        this.user = Objects.requireNonNull(user, "user");
        initBits &= ~INIT_BIT_USER;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#report() report} attribute.
       * @param report The value for report 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder report(String report) {
        this.report = Objects.requireNonNull(report, "report");
        initBits &= ~INIT_BIT_REPORT;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.Execution#executionId() executionId} attribute.
       * @param executionId The value for executionId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder executionId(Long executionId) {
        this.executionId = Objects.requireNonNull(executionId, "executionId");
        initBits &= ~INIT_BIT_EXECUTION_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableExecutionHistory.Execution Execution}.
       * @return An immutable instance of Execution
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableExecutionHistory.Execution build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableExecutionHistory.Execution(
            time,
            duration,
            status,
            info,
            error,
            testCaseTitle,
            environment,
            datasetId,
            datasetVersion,
            user,
            report,
            executionId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
        if ((initBits & INIT_BIT_DURATION) != 0) attributes.add("duration");
        if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
        if ((initBits & INIT_BIT_TEST_CASE_TITLE) != 0) attributes.add("testCaseTitle");
        if ((initBits & INIT_BIT_ENVIRONMENT) != 0) attributes.add("environment");
        if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
        if ((initBits & INIT_BIT_REPORT) != 0) attributes.add("report");
        if ((initBits & INIT_BIT_EXECUTION_ID) != 0) attributes.add("executionId");
        return "Cannot build Execution, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link ExecutionHistory.DetachedExecution}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableExecutionHistory.DetachedExecution.builder()}.
   */
  @Immutable
  @CheckReturnValue
  public static final class DetachedExecution
      implements ExecutionHistory.DetachedExecution {
    private final LocalDateTime time;
    private final long duration;
    private final ServerReportStatus status;
    private final @Nullable String info;
    private final @Nullable String error;
    private final String testCaseTitle;
    private final String environment;
    private final @Nullable String datasetId;
    private final @Nullable Integer datasetVersion;
    private final String user;
    private final String report;

    private DetachedExecution(
        LocalDateTime time,
        long duration,
        ServerReportStatus status,
        @Nullable String info,
        @Nullable String error,
        String testCaseTitle,
        String environment,
        @Nullable String datasetId,
        @Nullable Integer datasetVersion,
        String user,
        String report) {
      this.time = time;
      this.duration = duration;
      this.status = status;
      this.info = info;
      this.error = error;
      this.testCaseTitle = testCaseTitle;
      this.environment = environment;
      this.datasetId = datasetId;
      this.datasetVersion = datasetVersion;
      this.user = user;
      this.report = report;
    }

    /**
     * @return The value of the {@code time} attribute
     */
    @JsonProperty("time")
    @Override
    public LocalDateTime time() {
      return time;
    }

    /**
     * @return The value of the {@code duration} attribute
     */
    @JsonProperty("duration")
    @Override
    public long duration() {
      return duration;
    }

    /**
     * @return The value of the {@code status} attribute
     */
    @JsonProperty("status")
    @Override
    public ServerReportStatus status() {
      return status;
    }

    /**
     * @return The value of the {@code info} attribute
     */
    @JsonProperty("info")
    @Override
    public Optional<String> info() {
      return Optional.ofNullable(info);
    }

    /**
     * @return The value of the {@code error} attribute
     */
    @JsonProperty("error")
    @Override
    public Optional<String> error() {
      return Optional.ofNullable(error);
    }

    /**
     * @return The value of the {@code testCaseTitle} attribute
     */
    @JsonProperty("testCaseTitle")
    @Override
    public String testCaseTitle() {
      return testCaseTitle;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @JsonProperty("environment")
    @Override
    public String environment() {
      return environment;
    }

    /**
     * @return The value of the {@code datasetId} attribute
     */
    @JsonProperty("datasetId")
    @Override
    public Optional<String> datasetId() {
      return Optional.ofNullable(datasetId);
    }

    /**
     * @return The value of the {@code datasetVersion} attribute
     */
    @JsonProperty("datasetVersion")
    @Override
    public Optional<Integer> datasetVersion() {
      return Optional.ofNullable(datasetVersion);
    }

    /**
     * @return The value of the {@code user} attribute
     */
    @JsonProperty("user")
    @Override
    public String user() {
      return user;
    }

    /**
     * @return The value of the {@code report} attribute
     */
    @JsonProperty("report")
    @Override
    public String report() {
      return report;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#time() time} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for time
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withTime(LocalDateTime value) {
      if (this.time == value) return this;
      LocalDateTime newValue = Objects.requireNonNull(value, "time");
      return new ImmutableExecutionHistory.DetachedExecution(
          newValue,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#duration() duration} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for duration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withDuration(long value) {
      if (this.duration == value) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          value,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#status() status} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for status
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withStatus(ServerReportStatus value) {
      if (this.status == value) return this;
      ServerReportStatus newValue = Objects.requireNonNull(value, "status");
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          newValue,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.DetachedExecution#info() info} attribute.
     * @param value The value for info
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withInfo(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "info");
      if (Objects.equals(this.info, newValue)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          newValue,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.DetachedExecution#info() info} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for info
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withInfo(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.info, value)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          value,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.DetachedExecution#error() error} attribute.
     * @param value The value for error
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withError(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "error");
      if (Objects.equals(this.error, newValue)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          newValue,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.DetachedExecution#error() error} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for error
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withError(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.error, value)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          value,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#testCaseTitle() testCaseTitle} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for testCaseTitle
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withTestCaseTitle(String value) {
      if (this.testCaseTitle.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "testCaseTitle");
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          newValue,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#environment() environment} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withEnvironment(String value) {
      if (this.environment.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "environment");
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          newValue,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.DetachedExecution#datasetId() datasetId} attribute.
     * @param value The value for datasetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withDatasetId(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "datasetId");
      if (Objects.equals(this.datasetId, newValue)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          newValue,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.DetachedExecution#datasetId() datasetId} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for datasetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withDatasetId(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.datasetId, value)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          value,
          this.datasetVersion,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.DetachedExecution#datasetVersion() datasetVersion} attribute.
     * @param value The value for datasetVersion
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withDatasetVersion(int value) {
      @Nullable Integer newValue = value;
      if (Objects.equals(this.datasetVersion, newValue)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          newValue,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.DetachedExecution#datasetVersion() datasetVersion} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for datasetVersion
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withDatasetVersion(Optional<Integer> optional) {
      @Nullable Integer value = optional.orElse(null);
      if (Objects.equals(this.datasetVersion, value)) return this;
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          value,
          this.user,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#user() user} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for user
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withUser(String value) {
      if (this.user.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "user");
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          newValue,
          this.report);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.DetachedExecution#report() report} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for report
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.DetachedExecution withReport(String value) {
      if (this.report.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "report");
      return new ImmutableExecutionHistory.DetachedExecution(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          newValue);
    }

    /**
     * This instance is equal to all instances of {@code DetachedExecution} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableExecutionHistory.DetachedExecution
          && equalTo((ImmutableExecutionHistory.DetachedExecution) another);
    }

    private boolean equalTo(ImmutableExecutionHistory.DetachedExecution another) {
      return time.equals(another.time)
          && duration == another.duration
          && status.equals(another.status)
          && Objects.equals(info, another.info)
          && Objects.equals(error, another.error)
          && testCaseTitle.equals(another.testCaseTitle)
          && environment.equals(another.environment)
          && Objects.equals(datasetId, another.datasetId)
          && Objects.equals(datasetVersion, another.datasetVersion)
          && user.equals(another.user)
          && report.equals(another.report);
    }

    /**
     * Computes a hash code from attributes: {@code time}, {@code duration}, {@code status}, {@code info}, {@code error}, {@code testCaseTitle}, {@code environment}, {@code datasetId}, {@code datasetVersion}, {@code user}, {@code report}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + time.hashCode();
      h += (h << 5) + Longs.hashCode(duration);
      h += (h << 5) + status.hashCode();
      h += (h << 5) + Objects.hashCode(info);
      h += (h << 5) + Objects.hashCode(error);
      h += (h << 5) + testCaseTitle.hashCode();
      h += (h << 5) + environment.hashCode();
      h += (h << 5) + Objects.hashCode(datasetId);
      h += (h << 5) + Objects.hashCode(datasetVersion);
      h += (h << 5) + user.hashCode();
      h += (h << 5) + report.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code DetachedExecution} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("DetachedExecution")
          .omitNullValues()
          .add("time", time)
          .add("duration", duration)
          .add("status", status)
          .add("info", info)
          .add("error", error)
          .add("testCaseTitle", testCaseTitle)
          .add("environment", environment)
          .add("datasetId", datasetId)
          .add("datasetVersion", datasetVersion)
          .add("user", user)
          .add("report", report)
          .toString();
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json
        implements ExecutionHistory.DetachedExecution {
      @Nullable LocalDateTime time;
      long duration;
      boolean durationIsSet;
      @Nullable ServerReportStatus status;
      @Nullable Optional<String> info = Optional.empty();
      @Nullable Optional<String> error = Optional.empty();
      @Nullable String testCaseTitle;
      @Nullable String environment;
      @Nullable Optional<String> datasetId = Optional.empty();
      @Nullable Optional<Integer> datasetVersion = Optional.empty();
      @Nullable String user;
      @Nullable String report;
      @JsonProperty("time")
      public void setTime(LocalDateTime time) {
        this.time = time;
      }
      @JsonProperty("duration")
      public void setDuration(long duration) {
        this.duration = duration;
        this.durationIsSet = true;
      }
      @JsonProperty("status")
      public void setStatus(ServerReportStatus status) {
        this.status = status;
      }
      @JsonProperty("info")
      public void setInfo(Optional<String> info) {
        this.info = info;
      }
      @JsonProperty("error")
      public void setError(Optional<String> error) {
        this.error = error;
      }
      @JsonProperty("testCaseTitle")
      public void setTestCaseTitle(String testCaseTitle) {
        this.testCaseTitle = testCaseTitle;
      }
      @JsonProperty("environment")
      public void setEnvironment(String environment) {
        this.environment = environment;
      }
      @JsonProperty("datasetId")
      public void setDatasetId(Optional<String> datasetId) {
        this.datasetId = datasetId;
      }
      @JsonProperty("datasetVersion")
      public void setDatasetVersion(Optional<Integer> datasetVersion) {
        this.datasetVersion = datasetVersion;
      }
      @JsonProperty("user")
      public void setUser(String user) {
        this.user = user;
      }
      @JsonProperty("report")
      public void setReport(String report) {
        this.report = report;
      }
      @Override
      public LocalDateTime time() { throw new UnsupportedOperationException(); }
      @Override
      public long duration() { throw new UnsupportedOperationException(); }
      @Override
      public ServerReportStatus status() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> info() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> error() { throw new UnsupportedOperationException(); }
      @Override
      public String testCaseTitle() { throw new UnsupportedOperationException(); }
      @Override
      public String environment() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> datasetId() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<Integer> datasetVersion() { throw new UnsupportedOperationException(); }
      @Override
      public String user() { throw new UnsupportedOperationException(); }
      @Override
      public String report() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableExecutionHistory.DetachedExecution fromJson(Json json) {
      ImmutableExecutionHistory.DetachedExecution.Builder builder = ImmutableExecutionHistory.DetachedExecution.builder();
      if (json.time != null) {
        builder.time(json.time);
      }
      if (json.durationIsSet) {
        builder.duration(json.duration);
      }
      if (json.status != null) {
        builder.status(json.status);
      }
      if (json.info != null) {
        builder.info(json.info);
      }
      if (json.error != null) {
        builder.error(json.error);
      }
      if (json.testCaseTitle != null) {
        builder.testCaseTitle(json.testCaseTitle);
      }
      if (json.environment != null) {
        builder.environment(json.environment);
      }
      if (json.datasetId != null) {
        builder.datasetId(json.datasetId);
      }
      if (json.datasetVersion != null) {
        builder.datasetVersion(json.datasetVersion);
      }
      if (json.user != null) {
        builder.user(json.user);
      }
      if (json.report != null) {
        builder.report(json.report);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link ExecutionHistory.DetachedExecution} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable DetachedExecution instance
     */
    public static ImmutableExecutionHistory.DetachedExecution copyOf(ExecutionHistory.DetachedExecution instance) {
      if (instance instanceof ImmutableExecutionHistory.DetachedExecution) {
        return (ImmutableExecutionHistory.DetachedExecution) instance;
      }
      return ImmutableExecutionHistory.DetachedExecution.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableExecutionHistory.DetachedExecution DetachedExecution}.
     * @return A new DetachedExecution builder
     */
    public static ImmutableExecutionHistory.DetachedExecution.Builder builder() {
      return new ImmutableExecutionHistory.DetachedExecution.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableExecutionHistory.DetachedExecution DetachedExecution}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TIME = 0x1L;
      private static final long INIT_BIT_DURATION = 0x2L;
      private static final long INIT_BIT_STATUS = 0x4L;
      private static final long INIT_BIT_TEST_CASE_TITLE = 0x8L;
      private static final long INIT_BIT_ENVIRONMENT = 0x10L;
      private static final long INIT_BIT_USER = 0x20L;
      private static final long INIT_BIT_REPORT = 0x40L;
      private long initBits = 0x7fL;

      private @Nullable LocalDateTime time;
      private long duration;
      private @Nullable ServerReportStatus status;
      private @Nullable String info;
      private @Nullable String error;
      private @Nullable String testCaseTitle;
      private @Nullable String environment;
      private @Nullable String datasetId;
      private @Nullable Integer datasetVersion;
      private @Nullable String user;
      private @Nullable String report;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.ExecutionProperties} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.ExecutionProperties instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.HavingReport} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(HavingReport instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.DetachedExecution} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.DetachedExecution instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof ExecutionHistory.ExecutionProperties) {
          ExecutionHistory.ExecutionProperties instance = (ExecutionHistory.ExecutionProperties) object;
          duration(instance.duration());
          environment(instance.environment());
          Optional<Integer> datasetVersionOptional = instance.datasetVersion();
          if (datasetVersionOptional.isPresent()) {
            datasetVersion(datasetVersionOptional);
          }
          Optional<String> datasetIdOptional = instance.datasetId();
          if (datasetIdOptional.isPresent()) {
            datasetId(datasetIdOptional);
          }
          time(instance.time());
          Optional<String> errorOptional = instance.error();
          if (errorOptional.isPresent()) {
            error(errorOptional);
          }
          testCaseTitle(instance.testCaseTitle());
          user(instance.user());
          status(instance.status());
          Optional<String> infoOptional = instance.info();
          if (infoOptional.isPresent()) {
            info(infoOptional);
          }
        }
        if (object instanceof HavingReport) {
          HavingReport instance = (HavingReport) object;
          report(instance.report());
        }
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#time() time} attribute.
       * @param time The value for time 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder time(LocalDateTime time) {
        this.time = Objects.requireNonNull(time, "time");
        initBits &= ~INIT_BIT_TIME;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#duration() duration} attribute.
       * @param duration The value for duration 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder duration(long duration) {
        this.duration = duration;
        initBits &= ~INIT_BIT_DURATION;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#status() status} attribute.
       * @param status The value for status 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder status(ServerReportStatus status) {
        this.status = Objects.requireNonNull(status, "status");
        initBits &= ~INIT_BIT_STATUS;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#info() info} to info.
       * @param info The value for info
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder info(String info) {
        this.info = Objects.requireNonNull(info, "info");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#info() info} to info.
       * @param info The value for info
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder info(Optional<String> info) {
        this.info = info.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#error() error} to error.
       * @param error The value for error
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder error(String error) {
        this.error = Objects.requireNonNull(error, "error");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#error() error} to error.
       * @param error The value for error
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder error(Optional<String> error) {
        this.error = error.orElse(null);
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#testCaseTitle() testCaseTitle} attribute.
       * @param testCaseTitle The value for testCaseTitle 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder testCaseTitle(String testCaseTitle) {
        this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
        initBits &= ~INIT_BIT_TEST_CASE_TITLE;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#environment() environment} attribute.
       * @param environment The value for environment 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder environment(String environment) {
        this.environment = Objects.requireNonNull(environment, "environment");
        initBits &= ~INIT_BIT_ENVIRONMENT;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#datasetId() datasetId} to datasetId.
       * @param datasetId The value for datasetId
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetId(String datasetId) {
        this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#datasetId() datasetId} to datasetId.
       * @param datasetId The value for datasetId
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetId(Optional<String> datasetId) {
        this.datasetId = datasetId.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#datasetVersion() datasetVersion} to datasetVersion.
       * @param datasetVersion The value for datasetVersion
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetVersion(int datasetVersion) {
        this.datasetVersion = datasetVersion;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.DetachedExecution#datasetVersion() datasetVersion} to datasetVersion.
       * @param datasetVersion The value for datasetVersion
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetVersion(Optional<Integer> datasetVersion) {
        this.datasetVersion = datasetVersion.orElse(null);
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#user() user} attribute.
       * @param user The value for user 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder user(String user) {
        this.user = Objects.requireNonNull(user, "user");
        initBits &= ~INIT_BIT_USER;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.DetachedExecution#report() report} attribute.
       * @param report The value for report 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder report(String report) {
        this.report = Objects.requireNonNull(report, "report");
        initBits &= ~INIT_BIT_REPORT;
        return this;
      }

      /**
       * Builds a new {@link ImmutableExecutionHistory.DetachedExecution DetachedExecution}.
       * @return An immutable instance of DetachedExecution
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableExecutionHistory.DetachedExecution build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableExecutionHistory.DetachedExecution(
            time,
            duration,
            status,
            info,
            error,
            testCaseTitle,
            environment,
            datasetId,
            datasetVersion,
            user,
            report);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
        if ((initBits & INIT_BIT_DURATION) != 0) attributes.add("duration");
        if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
        if ((initBits & INIT_BIT_TEST_CASE_TITLE) != 0) attributes.add("testCaseTitle");
        if ((initBits & INIT_BIT_ENVIRONMENT) != 0) attributes.add("environment");
        if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
        if ((initBits & INIT_BIT_REPORT) != 0) attributes.add("report");
        return "Cannot build DetachedExecution, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link ExecutionHistory.ExecutionSummary}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableExecutionHistory.ExecutionSummary.builder()}.
   */
  @Immutable
  @CheckReturnValue
  public static final class ExecutionSummary
      implements ExecutionHistory.ExecutionSummary {
    private final LocalDateTime time;
    private final long duration;
    private final ServerReportStatus status;
    private final @Nullable String info;
    private final @Nullable String error;
    private final String testCaseTitle;
    private final String environment;
    private final @Nullable String datasetId;
    private final @Nullable Integer datasetVersion;
    private final String user;
    private final Long executionId;

    private ExecutionSummary(
        LocalDateTime time,
        long duration,
        ServerReportStatus status,
        @Nullable String info,
        @Nullable String error,
        String testCaseTitle,
        String environment,
        @Nullable String datasetId,
        @Nullable Integer datasetVersion,
        String user,
        Long executionId) {
      this.time = time;
      this.duration = duration;
      this.status = status;
      this.info = info;
      this.error = error;
      this.testCaseTitle = testCaseTitle;
      this.environment = environment;
      this.datasetId = datasetId;
      this.datasetVersion = datasetVersion;
      this.user = user;
      this.executionId = executionId;
    }

    /**
     * @return The value of the {@code time} attribute
     */
    @JsonProperty("time")
    @Override
    public LocalDateTime time() {
      return time;
    }

    /**
     * @return The value of the {@code duration} attribute
     */
    @JsonProperty("duration")
    @Override
    public long duration() {
      return duration;
    }

    /**
     * @return The value of the {@code status} attribute
     */
    @JsonProperty("status")
    @Override
    public ServerReportStatus status() {
      return status;
    }

    /**
     * @return The value of the {@code info} attribute
     */
    @JsonProperty("info")
    @Override
    public Optional<String> info() {
      return Optional.ofNullable(info);
    }

    /**
     * @return The value of the {@code error} attribute
     */
    @JsonProperty("error")
    @Override
    public Optional<String> error() {
      return Optional.ofNullable(error);
    }

    /**
     * @return The value of the {@code testCaseTitle} attribute
     */
    @JsonProperty("testCaseTitle")
    @Override
    public String testCaseTitle() {
      return testCaseTitle;
    }

    /**
     * @return The value of the {@code environment} attribute
     */
    @JsonProperty("environment")
    @Override
    public String environment() {
      return environment;
    }

    /**
     * @return The value of the {@code datasetId} attribute
     */
    @JsonProperty("datasetId")
    @Override
    public Optional<String> datasetId() {
      return Optional.ofNullable(datasetId);
    }

    /**
     * @return The value of the {@code datasetVersion} attribute
     */
    @JsonProperty("datasetVersion")
    @Override
    public Optional<Integer> datasetVersion() {
      return Optional.ofNullable(datasetVersion);
    }

    /**
     * @return The value of the {@code user} attribute
     */
    @JsonProperty("user")
    @Override
    public String user() {
      return user;
    }

    /**
     * @return The value of the {@code executionId} attribute
     */
    @JsonProperty("executionId")
    @Override
    public Long executionId() {
      return executionId;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#time() time} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for time
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withTime(LocalDateTime value) {
      if (this.time == value) return this;
      LocalDateTime newValue = Objects.requireNonNull(value, "time");
      return new ImmutableExecutionHistory.ExecutionSummary(
          newValue,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#duration() duration} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for duration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withDuration(long value) {
      if (this.duration == value) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          value,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#status() status} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for status
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withStatus(ServerReportStatus value) {
      if (this.status == value) return this;
      ServerReportStatus newValue = Objects.requireNonNull(value, "status");
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          newValue,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.ExecutionSummary#info() info} attribute.
     * @param value The value for info
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withInfo(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "info");
      if (Objects.equals(this.info, newValue)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          newValue,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.ExecutionSummary#info() info} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for info
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withInfo(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.info, value)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          value,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.ExecutionSummary#error() error} attribute.
     * @param value The value for error
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withError(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "error");
      if (Objects.equals(this.error, newValue)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          newValue,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.ExecutionSummary#error() error} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for error
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withError(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.error, value)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          value,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#testCaseTitle() testCaseTitle} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for testCaseTitle
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withTestCaseTitle(String value) {
      if (this.testCaseTitle.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "testCaseTitle");
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          newValue,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#environment() environment} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for environment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withEnvironment(String value) {
      if (this.environment.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "environment");
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          newValue,
          this.datasetId,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.ExecutionSummary#datasetId() datasetId} attribute.
     * @param value The value for datasetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withDatasetId(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "datasetId");
      if (Objects.equals(this.datasetId, newValue)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          newValue,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.ExecutionSummary#datasetId() datasetId} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for datasetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withDatasetId(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.datasetId, value)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          value,
          this.datasetVersion,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionHistory.ExecutionSummary#datasetVersion() datasetVersion} attribute.
     * @param value The value for datasetVersion
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withDatasetVersion(int value) {
      @Nullable Integer newValue = value;
      if (Objects.equals(this.datasetVersion, newValue)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          newValue,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link ExecutionHistory.ExecutionSummary#datasetVersion() datasetVersion} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for datasetVersion
     * @return A modified copy of {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withDatasetVersion(Optional<Integer> optional) {
      @Nullable Integer value = optional.orElse(null);
      if (Objects.equals(this.datasetVersion, value)) return this;
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          value,
          this.user,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#user() user} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for user
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withUser(String value) {
      if (this.user.equals(value)) return this;
      String newValue = Objects.requireNonNull(value, "user");
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          newValue,
          this.executionId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link ExecutionHistory.ExecutionSummary#executionId() executionId} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for executionId
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableExecutionHistory.ExecutionSummary withExecutionId(Long value) {
      if (this.executionId.equals(value)) return this;
      Long newValue = Objects.requireNonNull(value, "executionId");
      return new ImmutableExecutionHistory.ExecutionSummary(
          this.time,
          this.duration,
          this.status,
          this.info,
          this.error,
          this.testCaseTitle,
          this.environment,
          this.datasetId,
          this.datasetVersion,
          this.user,
          newValue);
    }

    /**
     * This instance is equal to all instances of {@code ExecutionSummary} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableExecutionHistory.ExecutionSummary
          && equalTo((ImmutableExecutionHistory.ExecutionSummary) another);
    }

    private boolean equalTo(ImmutableExecutionHistory.ExecutionSummary another) {
      return time.equals(another.time)
          && duration == another.duration
          && status.equals(another.status)
          && Objects.equals(info, another.info)
          && Objects.equals(error, another.error)
          && testCaseTitle.equals(another.testCaseTitle)
          && environment.equals(another.environment)
          && Objects.equals(datasetId, another.datasetId)
          && Objects.equals(datasetVersion, another.datasetVersion)
          && user.equals(another.user)
          && executionId.equals(another.executionId);
    }

    /**
     * Computes a hash code from attributes: {@code time}, {@code duration}, {@code status}, {@code info}, {@code error}, {@code testCaseTitle}, {@code environment}, {@code datasetId}, {@code datasetVersion}, {@code user}, {@code executionId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + time.hashCode();
      h += (h << 5) + Longs.hashCode(duration);
      h += (h << 5) + status.hashCode();
      h += (h << 5) + Objects.hashCode(info);
      h += (h << 5) + Objects.hashCode(error);
      h += (h << 5) + testCaseTitle.hashCode();
      h += (h << 5) + environment.hashCode();
      h += (h << 5) + Objects.hashCode(datasetId);
      h += (h << 5) + Objects.hashCode(datasetVersion);
      h += (h << 5) + user.hashCode();
      h += (h << 5) + executionId.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ExecutionSummary} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ExecutionSummary")
          .omitNullValues()
          .add("time", time)
          .add("duration", duration)
          .add("status", status)
          .add("info", info)
          .add("error", error)
          .add("testCaseTitle", testCaseTitle)
          .add("environment", environment)
          .add("datasetId", datasetId)
          .add("datasetVersion", datasetVersion)
          .add("user", user)
          .add("executionId", executionId)
          .toString();
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json
        implements ExecutionHistory.ExecutionSummary {
      @Nullable LocalDateTime time;
      long duration;
      boolean durationIsSet;
      @Nullable ServerReportStatus status;
      @Nullable Optional<String> info = Optional.empty();
      @Nullable Optional<String> error = Optional.empty();
      @Nullable String testCaseTitle;
      @Nullable String environment;
      @Nullable Optional<String> datasetId = Optional.empty();
      @Nullable Optional<Integer> datasetVersion = Optional.empty();
      @Nullable String user;
      @Nullable Long executionId;
      @JsonProperty("time")
      public void setTime(LocalDateTime time) {
        this.time = time;
      }
      @JsonProperty("duration")
      public void setDuration(long duration) {
        this.duration = duration;
        this.durationIsSet = true;
      }
      @JsonProperty("status")
      public void setStatus(ServerReportStatus status) {
        this.status = status;
      }
      @JsonProperty("info")
      public void setInfo(Optional<String> info) {
        this.info = info;
      }
      @JsonProperty("error")
      public void setError(Optional<String> error) {
        this.error = error;
      }
      @JsonProperty("testCaseTitle")
      public void setTestCaseTitle(String testCaseTitle) {
        this.testCaseTitle = testCaseTitle;
      }
      @JsonProperty("environment")
      public void setEnvironment(String environment) {
        this.environment = environment;
      }
      @JsonProperty("datasetId")
      public void setDatasetId(Optional<String> datasetId) {
        this.datasetId = datasetId;
      }
      @JsonProperty("datasetVersion")
      public void setDatasetVersion(Optional<Integer> datasetVersion) {
        this.datasetVersion = datasetVersion;
      }
      @JsonProperty("user")
      public void setUser(String user) {
        this.user = user;
      }
      @JsonProperty("executionId")
      public void setExecutionId(Long executionId) {
        this.executionId = executionId;
      }
      @Override
      public LocalDateTime time() { throw new UnsupportedOperationException(); }
      @Override
      public long duration() { throw new UnsupportedOperationException(); }
      @Override
      public ServerReportStatus status() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> info() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> error() { throw new UnsupportedOperationException(); }
      @Override
      public String testCaseTitle() { throw new UnsupportedOperationException(); }
      @Override
      public String environment() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<String> datasetId() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<Integer> datasetVersion() { throw new UnsupportedOperationException(); }
      @Override
      public String user() { throw new UnsupportedOperationException(); }
      @Override
      public Long executionId() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableExecutionHistory.ExecutionSummary fromJson(Json json) {
      ImmutableExecutionHistory.ExecutionSummary.Builder builder = ImmutableExecutionHistory.ExecutionSummary.builder();
      if (json.time != null) {
        builder.time(json.time);
      }
      if (json.durationIsSet) {
        builder.duration(json.duration);
      }
      if (json.status != null) {
        builder.status(json.status);
      }
      if (json.info != null) {
        builder.info(json.info);
      }
      if (json.error != null) {
        builder.error(json.error);
      }
      if (json.testCaseTitle != null) {
        builder.testCaseTitle(json.testCaseTitle);
      }
      if (json.environment != null) {
        builder.environment(json.environment);
      }
      if (json.datasetId != null) {
        builder.datasetId(json.datasetId);
      }
      if (json.datasetVersion != null) {
        builder.datasetVersion(json.datasetVersion);
      }
      if (json.user != null) {
        builder.user(json.user);
      }
      if (json.executionId != null) {
        builder.executionId(json.executionId);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link ExecutionHistory.ExecutionSummary} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ExecutionSummary instance
     */
    public static ImmutableExecutionHistory.ExecutionSummary copyOf(ExecutionHistory.ExecutionSummary instance) {
      if (instance instanceof ImmutableExecutionHistory.ExecutionSummary) {
        return (ImmutableExecutionHistory.ExecutionSummary) instance;
      }
      return ImmutableExecutionHistory.ExecutionSummary.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableExecutionHistory.ExecutionSummary ExecutionSummary}.
     * @return A new ExecutionSummary builder
     */
    public static ImmutableExecutionHistory.ExecutionSummary.Builder builder() {
      return new ImmutableExecutionHistory.ExecutionSummary.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableExecutionHistory.ExecutionSummary ExecutionSummary}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TIME = 0x1L;
      private static final long INIT_BIT_DURATION = 0x2L;
      private static final long INIT_BIT_STATUS = 0x4L;
      private static final long INIT_BIT_TEST_CASE_TITLE = 0x8L;
      private static final long INIT_BIT_ENVIRONMENT = 0x10L;
      private static final long INIT_BIT_USER = 0x20L;
      private static final long INIT_BIT_EXECUTION_ID = 0x40L;
      private long initBits = 0x7fL;

      private @Nullable LocalDateTime time;
      private long duration;
      private @Nullable ServerReportStatus status;
      private @Nullable String info;
      private @Nullable String error;
      private @Nullable String testCaseTitle;
      private @Nullable String environment;
      private @Nullable String datasetId;
      private @Nullable Integer datasetVersion;
      private @Nullable String user;
      private @Nullable Long executionId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.Attached} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.Attached instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.ExecutionProperties} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.ExecutionProperties instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.domain.history.ExecutionHistory.ExecutionSummary} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(ExecutionHistory.ExecutionSummary instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof ExecutionHistory.Attached) {
          ExecutionHistory.Attached instance = (ExecutionHistory.Attached) object;
          executionId(instance.executionId());
        }
        if (object instanceof ExecutionHistory.ExecutionProperties) {
          ExecutionHistory.ExecutionProperties instance = (ExecutionHistory.ExecutionProperties) object;
          duration(instance.duration());
          environment(instance.environment());
          Optional<Integer> datasetVersionOptional = instance.datasetVersion();
          if (datasetVersionOptional.isPresent()) {
            datasetVersion(datasetVersionOptional);
          }
          Optional<String> datasetIdOptional = instance.datasetId();
          if (datasetIdOptional.isPresent()) {
            datasetId(datasetIdOptional);
          }
          time(instance.time());
          Optional<String> errorOptional = instance.error();
          if (errorOptional.isPresent()) {
            error(errorOptional);
          }
          testCaseTitle(instance.testCaseTitle());
          user(instance.user());
          status(instance.status());
          Optional<String> infoOptional = instance.info();
          if (infoOptional.isPresent()) {
            info(infoOptional);
          }
        }
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#time() time} attribute.
       * @param time The value for time 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder time(LocalDateTime time) {
        this.time = Objects.requireNonNull(time, "time");
        initBits &= ~INIT_BIT_TIME;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#duration() duration} attribute.
       * @param duration The value for duration 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder duration(long duration) {
        this.duration = duration;
        initBits &= ~INIT_BIT_DURATION;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#status() status} attribute.
       * @param status The value for status 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder status(ServerReportStatus status) {
        this.status = Objects.requireNonNull(status, "status");
        initBits &= ~INIT_BIT_STATUS;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#info() info} to info.
       * @param info The value for info
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder info(String info) {
        this.info = Objects.requireNonNull(info, "info");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#info() info} to info.
       * @param info The value for info
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder info(Optional<String> info) {
        this.info = info.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#error() error} to error.
       * @param error The value for error
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder error(String error) {
        this.error = Objects.requireNonNull(error, "error");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#error() error} to error.
       * @param error The value for error
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder error(Optional<String> error) {
        this.error = error.orElse(null);
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#testCaseTitle() testCaseTitle} attribute.
       * @param testCaseTitle The value for testCaseTitle 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder testCaseTitle(String testCaseTitle) {
        this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
        initBits &= ~INIT_BIT_TEST_CASE_TITLE;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#environment() environment} attribute.
       * @param environment The value for environment 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder environment(String environment) {
        this.environment = Objects.requireNonNull(environment, "environment");
        initBits &= ~INIT_BIT_ENVIRONMENT;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#datasetId() datasetId} to datasetId.
       * @param datasetId The value for datasetId
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetId(String datasetId) {
        this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#datasetId() datasetId} to datasetId.
       * @param datasetId The value for datasetId
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetId(Optional<String> datasetId) {
        this.datasetId = datasetId.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#datasetVersion() datasetVersion} to datasetVersion.
       * @param datasetVersion The value for datasetVersion
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetVersion(int datasetVersion) {
        this.datasetVersion = datasetVersion;
        return this;
      }

      /**
       * Initializes the optional value {@link ExecutionHistory.ExecutionSummary#datasetVersion() datasetVersion} to datasetVersion.
       * @param datasetVersion The value for datasetVersion
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder datasetVersion(Optional<Integer> datasetVersion) {
        this.datasetVersion = datasetVersion.orElse(null);
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#user() user} attribute.
       * @param user The value for user 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder user(String user) {
        this.user = Objects.requireNonNull(user, "user");
        initBits &= ~INIT_BIT_USER;
        return this;
      }

      /**
       * Initializes the value for the {@link ExecutionHistory.ExecutionSummary#executionId() executionId} attribute.
       * @param executionId The value for executionId 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder executionId(Long executionId) {
        this.executionId = Objects.requireNonNull(executionId, "executionId");
        initBits &= ~INIT_BIT_EXECUTION_ID;
        return this;
      }

      /**
       * Builds a new {@link ImmutableExecutionHistory.ExecutionSummary ExecutionSummary}.
       * @return An immutable instance of ExecutionSummary
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableExecutionHistory.ExecutionSummary build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableExecutionHistory.ExecutionSummary(
            time,
            duration,
            status,
            info,
            error,
            testCaseTitle,
            environment,
            datasetId,
            datasetVersion,
            user,
            executionId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
        if ((initBits & INIT_BIT_DURATION) != 0) attributes.add("duration");
        if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
        if ((initBits & INIT_BIT_TEST_CASE_TITLE) != 0) attributes.add("testCaseTitle");
        if ((initBits & INIT_BIT_ENVIRONMENT) != 0) attributes.add("environment");
        if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
        if ((initBits & INIT_BIT_EXECUTION_ID) != 0) attributes.add("executionId");
        return "Cannot build ExecutionSummary, some of required attributes are not set " + attributes;
      }
    }
  }
}
