package com.chutneytesting.design.api.scenario.compose.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Strategy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStrategy.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Strategy"})
@Immutable
@CheckReturnValue
public final class ImmutableStrategy implements Strategy {
  private final String type;
  private final Map<String, Object> parameters;

  private ImmutableStrategy(ImmutableStrategy.Builder builder) {
    this.parameters = createUnmodifiableMap(false, false, builder.parameters);
    this.type = builder.type != null
        ? builder.type
        : Objects.requireNonNull(Strategy.super.type(), "type");
  }

  private ImmutableStrategy(String type, Map<String, Object> parameters) {
    this.type = type;
    this.parameters = parameters;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @JsonProperty("parameters")
  @Override
  public Map<String, Object> parameters() {
    return parameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Strategy#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStrategy withType(String value) {
    if (this.type.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "type");
    return new ImmutableStrategy(newValue, this.parameters);
  }

  /**
   * Copy the current immutable object by replacing the {@link Strategy#parameters() parameters} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the parameters map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStrategy withParameters(Map<String, ? extends Object> entries) {
    if (this.parameters == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableStrategy(this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStrategy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStrategy
        && equalTo((ImmutableStrategy) another);
  }

  private boolean equalTo(ImmutableStrategy another) {
    return type.equals(another.type)
        && parameters.equals(another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Strategy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Strategy{"
        + "type=" + type
        + ", parameters=" + parameters
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Strategy {
    @Nullable String type;
    @Nullable Map<String, Object> parameters = Collections.emptyMap();
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("parameters")
    public void setParameters(Map<String, Object> parameters) {
      this.parameters = parameters;
    }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> parameters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStrategy fromJson(Json json) {
    ImmutableStrategy.Builder builder = ImmutableStrategy.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.parameters != null) {
      builder.putAllParameters(json.parameters);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Strategy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Strategy instance
   */
  public static ImmutableStrategy copyOf(Strategy instance) {
    if (instance instanceof ImmutableStrategy) {
      return (ImmutableStrategy) instance;
    }
    return ImmutableStrategy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStrategy ImmutableStrategy}.
   * @return A new ImmutableStrategy builder
   */
  public static ImmutableStrategy.Builder builder() {
    return new ImmutableStrategy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStrategy ImmutableStrategy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String type;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Strategy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Strategy instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      putAllParameters(instance.parameters());
      return this;
    }

    /**
     * Initializes the value for the {@link Strategy#type() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Strategy#type() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Put one entry to the {@link Strategy#parameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putParameters(String key, Object value) {
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, "parameters value"));
      return this;
    }

    /**
     * Put one entry to the {@link Strategy#parameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putParameters(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, "parameters value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Strategy#parameters() parameters} map. Nulls are not permitted
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parameters")
    public final Builder parameters(Map<String, ? extends Object> parameters) {
      this.parameters.clear();
      return putAllParameters(parameters);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Strategy#parameters() parameters} map. Nulls are not permitted
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
      for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, "parameters value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableStrategy ImmutableStrategy}.
     * @return An immutable instance of Strategy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStrategy build() {
      return new ImmutableStrategy(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
