package com.chutneytesting.design.api.scenario.compose.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ParentsStepDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParentsStepDto.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ParentsStepDto"})
@Immutable
@CheckReturnValue
public final class ImmutableParentsStepDto
    implements ParentsStepDto {
  private final List<ParentsStepDto.NameIdDto> parentSteps;
  private final List<ParentsStepDto.NameIdDto> parentScenario;

  private ImmutableParentsStepDto(
      List<ParentsStepDto.NameIdDto> parentSteps,
      List<ParentsStepDto.NameIdDto> parentScenario) {
    this.parentSteps = parentSteps;
    this.parentScenario = parentScenario;
  }

  /**
   * @return The value of the {@code parentSteps} attribute
   */
  @JsonProperty("parentSteps")
  @Override
  public List<ParentsStepDto.NameIdDto> parentSteps() {
    return parentSteps;
  }

  /**
   * @return The value of the {@code parentScenario} attribute
   */
  @JsonProperty("parentScenario")
  @Override
  public List<ParentsStepDto.NameIdDto> parentScenario() {
    return parentScenario;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParentsStepDto#parentSteps() parentSteps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParentsStepDto withParentSteps(ParentsStepDto.NameIdDto... elements) {
    List<ParentsStepDto.NameIdDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableParentsStepDto(newValue, this.parentScenario);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParentsStepDto#parentSteps() parentSteps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parentSteps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParentsStepDto withParentSteps(Iterable<? extends ParentsStepDto.NameIdDto> elements) {
    if (this.parentSteps == elements) return this;
    List<ParentsStepDto.NameIdDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableParentsStepDto(newValue, this.parentScenario);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParentsStepDto#parentScenario() parentScenario}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParentsStepDto withParentScenario(ParentsStepDto.NameIdDto... elements) {
    List<ParentsStepDto.NameIdDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableParentsStepDto(this.parentSteps, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParentsStepDto#parentScenario() parentScenario}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parentScenario elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParentsStepDto withParentScenario(Iterable<? extends ParentsStepDto.NameIdDto> elements) {
    if (this.parentScenario == elements) return this;
    List<ParentsStepDto.NameIdDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableParentsStepDto(this.parentSteps, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParentsStepDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParentsStepDto
        && equalTo((ImmutableParentsStepDto) another);
  }

  private boolean equalTo(ImmutableParentsStepDto another) {
    return parentSteps.equals(another.parentSteps)
        && parentScenario.equals(another.parentScenario);
  }

  /**
   * Computes a hash code from attributes: {@code parentSteps}, {@code parentScenario}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + parentSteps.hashCode();
    h += (h << 5) + parentScenario.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ParentsStepDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ParentsStepDto{"
        + "parentSteps=" + parentSteps
        + ", parentScenario=" + parentScenario
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ParentsStepDto {
    @Nullable List<ParentsStepDto.NameIdDto> parentSteps = Collections.emptyList();
    @Nullable List<ParentsStepDto.NameIdDto> parentScenario = Collections.emptyList();
    @JsonProperty("parentSteps")
    public void setParentSteps(List<ParentsStepDto.NameIdDto> parentSteps) {
      this.parentSteps = parentSteps;
    }
    @JsonProperty("parentScenario")
    public void setParentScenario(List<ParentsStepDto.NameIdDto> parentScenario) {
      this.parentScenario = parentScenario;
    }
    @Override
    public List<ParentsStepDto.NameIdDto> parentSteps() { throw new UnsupportedOperationException(); }
    @Override
    public List<ParentsStepDto.NameIdDto> parentScenario() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableParentsStepDto fromJson(Json json) {
    ImmutableParentsStepDto.Builder builder = ImmutableParentsStepDto.builder();
    if (json.parentSteps != null) {
      builder.addAllParentSteps(json.parentSteps);
    }
    if (json.parentScenario != null) {
      builder.addAllParentScenario(json.parentScenario);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ParentsStepDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ParentsStepDto instance
   */
  public static ImmutableParentsStepDto copyOf(ParentsStepDto instance) {
    if (instance instanceof ImmutableParentsStepDto) {
      return (ImmutableParentsStepDto) instance;
    }
    return ImmutableParentsStepDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParentsStepDto ImmutableParentsStepDto}.
   * @return A new ImmutableParentsStepDto builder
   */
  public static ImmutableParentsStepDto.Builder builder() {
    return new ImmutableParentsStepDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParentsStepDto ImmutableParentsStepDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<ParentsStepDto.NameIdDto> parentSteps = new ArrayList<ParentsStepDto.NameIdDto>();
    private List<ParentsStepDto.NameIdDto> parentScenario = new ArrayList<ParentsStepDto.NameIdDto>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ParentsStepDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParentsStepDto instance) {
      Objects.requireNonNull(instance, "instance");
      addAllParentSteps(instance.parentSteps());
      addAllParentScenario(instance.parentScenario());
      return this;
    }

    /**
     * Adds one element to {@link ParentsStepDto#parentSteps() parentSteps} list.
     * @param element A parentSteps element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParentSteps(ParentsStepDto.NameIdDto element) {
      this.parentSteps.add(Objects.requireNonNull(element, "parentSteps element"));
      return this;
    }

    /**
     * Adds elements to {@link ParentsStepDto#parentSteps() parentSteps} list.
     * @param elements An array of parentSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParentSteps(ParentsStepDto.NameIdDto... elements) {
      for (ParentsStepDto.NameIdDto element : elements) {
        this.parentSteps.add(Objects.requireNonNull(element, "parentSteps element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ParentsStepDto#parentSteps() parentSteps} list.
     * @param elements An iterable of parentSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentSteps")
    public final Builder parentSteps(Iterable<? extends ParentsStepDto.NameIdDto> elements) {
      this.parentSteps.clear();
      return addAllParentSteps(elements);
    }

    /**
     * Adds elements to {@link ParentsStepDto#parentSteps() parentSteps} list.
     * @param elements An iterable of parentSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParentSteps(Iterable<? extends ParentsStepDto.NameIdDto> elements) {
      for (ParentsStepDto.NameIdDto element : elements) {
        this.parentSteps.add(Objects.requireNonNull(element, "parentSteps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ParentsStepDto#parentScenario() parentScenario} list.
     * @param element A parentScenario element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParentScenario(ParentsStepDto.NameIdDto element) {
      this.parentScenario.add(Objects.requireNonNull(element, "parentScenario element"));
      return this;
    }

    /**
     * Adds elements to {@link ParentsStepDto#parentScenario() parentScenario} list.
     * @param elements An array of parentScenario elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParentScenario(ParentsStepDto.NameIdDto... elements) {
      for (ParentsStepDto.NameIdDto element : elements) {
        this.parentScenario.add(Objects.requireNonNull(element, "parentScenario element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ParentsStepDto#parentScenario() parentScenario} list.
     * @param elements An iterable of parentScenario elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentScenario")
    public final Builder parentScenario(Iterable<? extends ParentsStepDto.NameIdDto> elements) {
      this.parentScenario.clear();
      return addAllParentScenario(elements);
    }

    /**
     * Adds elements to {@link ParentsStepDto#parentScenario() parentScenario} list.
     * @param elements An iterable of parentScenario elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParentScenario(Iterable<? extends ParentsStepDto.NameIdDto> elements) {
      for (ParentsStepDto.NameIdDto element : elements) {
        this.parentScenario.add(Objects.requireNonNull(element, "parentScenario element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableParentsStepDto ImmutableParentsStepDto}.
     * @return An immutable instance of ParentsStepDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParentsStepDto build() {
      return new ImmutableParentsStepDto(createUnmodifiableList(true, parentSteps), createUnmodifiableList(true, parentScenario));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
