package com.chutneytesting.design.api.scenario.compose.dto;

import com.chutneytesting.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ComposableTestCaseDto.ComposableScenarioDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposableScenarioDto.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ComposableTestCaseDto.ComposableScenarioDto"})
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableComposableScenarioDto
    implements ComposableTestCaseDto.ComposableScenarioDto {
  private final List<KeyValue> parameters;
  private final List<ComposableStepDto> componentSteps;

  private ImmutableComposableScenarioDto(ImmutableComposableScenarioDto.Builder builder) {
    if (builder.parametersIsSet()) {
      initShim.parameters(createUnmodifiableList(true, builder.parameters));
    }
    if (builder.componentStepsIsSet()) {
      initShim.componentSteps(createUnmodifiableList(true, builder.componentSteps));
    }
    this.parameters = initShim.parameters();
    this.componentSteps = initShim.componentSteps();
    this.initShim = null;
  }

  private ImmutableComposableScenarioDto(
      List<KeyValue> parameters,
      List<ComposableStepDto> componentSteps) {
    this.parameters = parameters;
    this.componentSteps = componentSteps;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private List<KeyValue> parameters;
    private int parametersBuildStage;

    List<KeyValue> parameters() {
      if (parametersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (parametersBuildStage == STAGE_UNINITIALIZED) {
        parametersBuildStage = STAGE_INITIALIZING;
        this.parameters = createUnmodifiableList(false, createSafeList(parametersInitialize(), true, false));
        parametersBuildStage = STAGE_INITIALIZED;
      }
      return this.parameters;
    }

    void parameters(List<KeyValue> parameters) {
      this.parameters = parameters;
      parametersBuildStage = STAGE_INITIALIZED;
    }
    private List<ComposableStepDto> componentSteps;
    private int componentStepsBuildStage;

    List<ComposableStepDto> componentSteps() {
      if (componentStepsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (componentStepsBuildStage == STAGE_UNINITIALIZED) {
        componentStepsBuildStage = STAGE_INITIALIZING;
        this.componentSteps = createUnmodifiableList(false, createSafeList(componentStepsInitialize(), true, false));
        componentStepsBuildStage = STAGE_INITIALIZED;
      }
      return this.componentSteps;
    }

    void componentSteps(List<ComposableStepDto> componentSteps) {
      this.componentSteps = componentSteps;
      componentStepsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (parametersBuildStage == STAGE_INITIALIZING) attributes.add("parameters");
      if (componentStepsBuildStage == STAGE_INITIALIZING) attributes.add("componentSteps");
      return "Cannot build ComposableScenarioDto, attribute initializers form cycle" + attributes;
    }
  }

  private List<KeyValue> parametersInitialize() {
    return ComposableTestCaseDto.ComposableScenarioDto.super.parameters();
  }

  private List<ComposableStepDto> componentStepsInitialize() {
    return ComposableTestCaseDto.ComposableScenarioDto.super.componentSteps();
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @JsonProperty("parameters")
  @Override
  public List<KeyValue> parameters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.parameters()
        : this.parameters;
  }

  /**
   * @return The value of the {@code componentSteps} attribute
   */
  @JsonProperty("componentSteps")
  @Override
  public List<ComposableStepDto> componentSteps() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.componentSteps()
        : this.componentSteps;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto.ComposableScenarioDto#parameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableScenarioDto withParameters(KeyValue... elements) {
    List<KeyValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableComposableScenarioDto(newValue, this.componentSteps);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto.ComposableScenarioDto#parameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableScenarioDto withParameters(Iterable<? extends KeyValue> elements) {
    if (this.parameters == elements) return this;
    List<KeyValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableComposableScenarioDto(newValue, this.componentSteps);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto.ComposableScenarioDto#componentSteps() componentSteps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableScenarioDto withComponentSteps(ComposableStepDto... elements) {
    List<ComposableStepDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableComposableScenarioDto(this.parameters, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto.ComposableScenarioDto#componentSteps() componentSteps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of componentSteps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableScenarioDto withComponentSteps(Iterable<? extends ComposableStepDto> elements) {
    if (this.componentSteps == elements) return this;
    List<ComposableStepDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableComposableScenarioDto(this.parameters, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposableScenarioDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposableScenarioDto
        && equalTo((ImmutableComposableScenarioDto) another);
  }

  private boolean equalTo(ImmutableComposableScenarioDto another) {
    return parameters.equals(another.parameters)
        && componentSteps.equals(another.componentSteps);
  }

  /**
   * Computes a hash code from attributes: {@code parameters}, {@code componentSteps}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + parameters.hashCode();
    h += (h << 5) + componentSteps.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposableScenarioDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ComposableScenarioDto{"
        + "parameters=" + parameters
        + ", componentSteps=" + componentSteps
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ComposableTestCaseDto.ComposableScenarioDto {
    @Nullable List<KeyValue> parameters = Collections.emptyList();
    boolean parametersIsSet;
    @Nullable List<ComposableStepDto> componentSteps = Collections.emptyList();
    boolean componentStepsIsSet;
    @JsonProperty("parameters")
    public void setParameters(List<KeyValue> parameters) {
      this.parameters = parameters;
      this.parametersIsSet = true;
    }
    @JsonProperty("componentSteps")
    public void setComponentSteps(List<ComposableStepDto> componentSteps) {
      this.componentSteps = componentSteps;
      this.componentStepsIsSet = true;
    }
    @Override
    public List<KeyValue> parameters() { throw new UnsupportedOperationException(); }
    @Override
    public List<ComposableStepDto> componentSteps() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComposableScenarioDto fromJson(Json json) {
    ImmutableComposableScenarioDto.Builder builder = ImmutableComposableScenarioDto.builder();
    if (json.parametersIsSet) {
      builder.addAllParameters(json.parameters);
    }
    if (json.componentStepsIsSet) {
      builder.addAllComponentSteps(json.componentSteps);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ComposableTestCaseDto.ComposableScenarioDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComposableScenarioDto instance
   */
  public static ImmutableComposableScenarioDto copyOf(ComposableTestCaseDto.ComposableScenarioDto instance) {
    if (instance instanceof ImmutableComposableScenarioDto) {
      return (ImmutableComposableScenarioDto) instance;
    }
    return ImmutableComposableScenarioDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposableScenarioDto ImmutableComposableScenarioDto}.
   * @return A new ImmutableComposableScenarioDto builder
   */
  public static ImmutableComposableScenarioDto.Builder builder() {
    return new ImmutableComposableScenarioDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComposableScenarioDto ImmutableComposableScenarioDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_PARAMETERS = 0x1L;
    private static final long OPT_BIT_COMPONENT_STEPS = 0x2L;
    private long optBits;

    private List<KeyValue> parameters = new ArrayList<KeyValue>();
    private List<ComposableStepDto> componentSteps = new ArrayList<ComposableStepDto>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposableScenarioDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ComposableTestCaseDto.ComposableScenarioDto instance) {
      Objects.requireNonNull(instance, "instance");
      addAllParameters(instance.parameters());
      addAllComponentSteps(instance.componentSteps());
      return this;
    }

    /**
     * Adds one element to {@link ComposableTestCaseDto.ComposableScenarioDto#parameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameters(KeyValue element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto.ComposableScenarioDto#parameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameters(KeyValue... elements) {
      for (KeyValue element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ComposableTestCaseDto.ComposableScenarioDto#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parameters")
    public final Builder parameters(Iterable<? extends KeyValue> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto.ComposableScenarioDto#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParameters(Iterable<? extends KeyValue> elements) {
      for (KeyValue element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Adds one element to {@link ComposableTestCaseDto.ComposableScenarioDto#componentSteps() componentSteps} list.
     * @param element A componentSteps element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addComponentSteps(ComposableStepDto element) {
      this.componentSteps.add(Objects.requireNonNull(element, "componentSteps element"));
      optBits |= OPT_BIT_COMPONENT_STEPS;
      return this;
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto.ComposableScenarioDto#componentSteps() componentSteps} list.
     * @param elements An array of componentSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addComponentSteps(ComposableStepDto... elements) {
      for (ComposableStepDto element : elements) {
        this.componentSteps.add(Objects.requireNonNull(element, "componentSteps element"));
      }
      optBits |= OPT_BIT_COMPONENT_STEPS;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ComposableTestCaseDto.ComposableScenarioDto#componentSteps() componentSteps} list.
     * @param elements An iterable of componentSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("componentSteps")
    public final Builder componentSteps(Iterable<? extends ComposableStepDto> elements) {
      this.componentSteps.clear();
      return addAllComponentSteps(elements);
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto.ComposableScenarioDto#componentSteps() componentSteps} list.
     * @param elements An iterable of componentSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllComponentSteps(Iterable<? extends ComposableStepDto> elements) {
      for (ComposableStepDto element : elements) {
        this.componentSteps.add(Objects.requireNonNull(element, "componentSteps element"));
      }
      optBits |= OPT_BIT_COMPONENT_STEPS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposableScenarioDto ImmutableComposableScenarioDto}.
     * @return An immutable instance of ComposableScenarioDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposableScenarioDto build() {
      return new ImmutableComposableScenarioDto(this);
    }

    private boolean parametersIsSet() {
      return (optBits & OPT_BIT_PARAMETERS) != 0;
    }

    private boolean componentStepsIsSet() {
      return (optBits & OPT_BIT_COMPONENT_STEPS) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
