package com.chutneytesting.design.api.plugins.jira;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JiraDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJiraDto.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JiraDto"})
@Immutable
@CheckReturnValue
public final class ImmutableJiraDto implements JiraDto {
  private final String id;
  private final String chutneyId;

  private ImmutableJiraDto(String id, String chutneyId) {
    this.id = id;
    this.chutneyId = chutneyId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code chutneyId} attribute
   */
  @JsonProperty("chutneyId")
  @Override
  public String chutneyId() {
    return chutneyId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraDto#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraDto withId(String value) {
    if (this.id.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "id");
    return new ImmutableJiraDto(newValue, this.chutneyId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraDto#chutneyId() chutneyId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chutneyId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraDto withChutneyId(String value) {
    if (this.chutneyId.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "chutneyId");
    return new ImmutableJiraDto(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJiraDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJiraDto
        && equalTo((ImmutableJiraDto) another);
  }

  private boolean equalTo(ImmutableJiraDto another) {
    return id.equals(another.id)
        && chutneyId.equals(another.chutneyId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code chutneyId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + chutneyId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JiraDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JiraDto{"
        + "id=" + id
        + ", chutneyId=" + chutneyId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JiraDto {
    @Nullable String id;
    @Nullable String chutneyId;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("chutneyId")
    public void setChutneyId(String chutneyId) {
      this.chutneyId = chutneyId;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String chutneyId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJiraDto fromJson(Json json) {
    ImmutableJiraDto.Builder builder = ImmutableJiraDto.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.chutneyId != null) {
      builder.chutneyId(json.chutneyId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JiraDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JiraDto instance
   */
  public static ImmutableJiraDto copyOf(JiraDto instance) {
    if (instance instanceof ImmutableJiraDto) {
      return (ImmutableJiraDto) instance;
    }
    return ImmutableJiraDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJiraDto ImmutableJiraDto}.
   * @return A new ImmutableJiraDto builder
   */
  public static ImmutableJiraDto.Builder builder() {
    return new ImmutableJiraDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJiraDto ImmutableJiraDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CHUTNEY_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String chutneyId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JiraDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JiraDto instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      chutneyId(instance.chutneyId());
      return this;
    }

    /**
     * Initializes the value for the {@link JiraDto#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraDto#chutneyId() chutneyId} attribute.
     * @param chutneyId The value for chutneyId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("chutneyId")
    public final Builder chutneyId(String chutneyId) {
      this.chutneyId = Objects.requireNonNull(chutneyId, "chutneyId");
      initBits &= ~INIT_BIT_CHUTNEY_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJiraDto ImmutableJiraDto}.
     * @return An immutable instance of JiraDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJiraDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJiraDto(id, chutneyId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CHUTNEY_ID) != 0) attributes.add("chutneyId");
      return "Cannot build JiraDto, some of required attributes are not set " + attributes;
    }
  }
}
