package com.chutneytesting.design.api.plugins.jira;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JiraConfigurationDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJiraConfigurationDto.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JiraConfigurationDto"})
@Immutable
@CheckReturnValue
public final class ImmutableJiraConfigurationDto
    implements JiraConfigurationDto {
  private final String url;
  private final String username;
  private final String password;

  private ImmutableJiraConfigurationDto(String url, String username, String password) {
    this.url = url;
    this.username = username;
    this.password = password;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty("url")
  @Override
  public String url() {
    return url;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty("username")
  @Override
  public String username() {
    return username;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @JsonProperty("password")
  @Override
  public String password() {
    return password;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraConfigurationDto#url() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraConfigurationDto withUrl(String value) {
    if (this.url.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "url");
    return new ImmutableJiraConfigurationDto(newValue, this.username, this.password);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraConfigurationDto#username() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for username
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraConfigurationDto withUsername(String value) {
    if (this.username.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "username");
    return new ImmutableJiraConfigurationDto(this.url, newValue, this.password);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraConfigurationDto#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraConfigurationDto withPassword(String value) {
    if (this.password.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "password");
    return new ImmutableJiraConfigurationDto(this.url, this.username, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJiraConfigurationDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJiraConfigurationDto
        && equalTo((ImmutableJiraConfigurationDto) another);
  }

  private boolean equalTo(ImmutableJiraConfigurationDto another) {
    return url.equals(another.url)
        && username.equals(another.username)
        && password.equals(another.password);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code username}, {@code password}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + url.hashCode();
    h += (h << 5) + username.hashCode();
    h += (h << 5) + password.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JiraConfigurationDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JiraConfigurationDto{"
        + "url=" + url
        + ", username=" + username
        + ", password=" + password
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JiraConfigurationDto {
    @Nullable String url;
    @Nullable String username;
    @Nullable String password;
    @JsonProperty("url")
    public void setUrl(String url) {
      this.url = url;
    }
    @JsonProperty("username")
    public void setUsername(String username) {
      this.username = username;
    }
    @JsonProperty("password")
    public void setPassword(String password) {
      this.password = password;
    }
    @Override
    public String url() { throw new UnsupportedOperationException(); }
    @Override
    public String username() { throw new UnsupportedOperationException(); }
    @Override
    public String password() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJiraConfigurationDto fromJson(Json json) {
    ImmutableJiraConfigurationDto.Builder builder = ImmutableJiraConfigurationDto.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    if (json.password != null) {
      builder.password(json.password);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JiraConfigurationDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JiraConfigurationDto instance
   */
  public static ImmutableJiraConfigurationDto copyOf(JiraConfigurationDto instance) {
    if (instance instanceof ImmutableJiraConfigurationDto) {
      return (ImmutableJiraConfigurationDto) instance;
    }
    return ImmutableJiraConfigurationDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJiraConfigurationDto ImmutableJiraConfigurationDto}.
   * @return A new ImmutableJiraConfigurationDto builder
   */
  public static ImmutableJiraConfigurationDto.Builder builder() {
    return new ImmutableJiraConfigurationDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJiraConfigurationDto ImmutableJiraConfigurationDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private static final long INIT_BIT_PASSWORD = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String url;
    private @Nullable String username;
    private @Nullable String password;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JiraConfigurationDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JiraConfigurationDto instance) {
      Objects.requireNonNull(instance, "instance");
      url(instance.url());
      username(instance.username());
      password(instance.password());
      return this;
    }

    /**
     * Initializes the value for the {@link JiraConfigurationDto#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("url")
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraConfigurationDto#username() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("username")
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraConfigurationDto#password() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("password")
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJiraConfigurationDto ImmutableJiraConfigurationDto}.
     * @return An immutable instance of JiraConfigurationDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJiraConfigurationDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJiraConfigurationDto(url, username, password);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      return "Cannot build JiraConfigurationDto, some of required attributes are not set " + attributes;
    }
  }
}
