/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.tools;

import com.chutneytesting.server.core.domain.tools.PaginationRequestWrapperDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PaginationRequestWrapperDto", generator="Immutables")
@Immutable
public final class ImmutablePaginationRequestWrapperDto<W>
implements PaginationRequestWrapperDto<W> {
    private final Integer pageNumber;
    private final Integer elementPerPage;
    private final Optional<W> wrappedRequest;

    private ImmutablePaginationRequestWrapperDto(Builder<W> builder) {
        this.pageNumber = builder.pageNumber;
        this.elementPerPage = builder.elementPerPage;
        this.wrappedRequest = builder.wrappedRequest != null ? builder.wrappedRequest : Objects.requireNonNull(PaginationRequestWrapperDto.super.wrappedRequest(), "wrappedRequest");
    }

    private ImmutablePaginationRequestWrapperDto(Integer pageNumber, Integer elementPerPage, Optional<W> wrappedRequest) {
        this.pageNumber = pageNumber;
        this.elementPerPage = elementPerPage;
        this.wrappedRequest = wrappedRequest;
    }

    @Override
    @JsonProperty(value="pageNumber")
    public Integer pageNumber() {
        return this.pageNumber;
    }

    @Override
    @JsonProperty(value="elementPerPage")
    public Integer elementPerPage() {
        return this.elementPerPage;
    }

    @Override
    @JsonProperty(value="wrappedRequest")
    public Optional<W> wrappedRequest() {
        return this.wrappedRequest;
    }

    public final ImmutablePaginationRequestWrapperDto<W> withPageNumber(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "pageNumber");
        if (this.pageNumber.equals(newValue)) {
            return this;
        }
        return new ImmutablePaginationRequestWrapperDto<W>(newValue, this.elementPerPage, this.wrappedRequest);
    }

    public final ImmutablePaginationRequestWrapperDto<W> withElementPerPage(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "elementPerPage");
        if (this.elementPerPage.equals(newValue)) {
            return this;
        }
        return new ImmutablePaginationRequestWrapperDto<W>(this.pageNumber, newValue, this.wrappedRequest);
    }

    public final ImmutablePaginationRequestWrapperDto<W> withWrappedRequest(Optional<W> value) {
        Optional<W> newValue = Objects.requireNonNull(value, "wrappedRequest");
        if (this.wrappedRequest.equals(newValue)) {
            return this;
        }
        return new ImmutablePaginationRequestWrapperDto<W>(this.pageNumber, this.elementPerPage, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaginationRequestWrapperDto && this.equalTo(0, (ImmutablePaginationRequestWrapperDto)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaginationRequestWrapperDto<?> another) {
        return this.pageNumber.equals(another.pageNumber) && this.elementPerPage.equals(another.elementPerPage) && this.wrappedRequest.equals(another.wrappedRequest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pageNumber.hashCode();
        h += (h << 5) + this.elementPerPage.hashCode();
        h += (h << 5) + this.wrappedRequest.hashCode();
        return h;
    }

    public String toString() {
        return "PaginationRequestWrapperDto{pageNumber=" + this.pageNumber + ", elementPerPage=" + this.elementPerPage + ", wrappedRequest=" + this.wrappedRequest + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <W> ImmutablePaginationRequestWrapperDto<W> fromJson(Json<W> json) {
        Builder builder = ImmutablePaginationRequestWrapperDto.builder();
        if (json.pageNumber != null) {
            builder.pageNumber(json.pageNumber);
        }
        if (json.elementPerPage != null) {
            builder.elementPerPage(json.elementPerPage);
        }
        if (json.wrappedRequest != null) {
            builder.wrappedRequest(json.wrappedRequest);
        }
        return builder.build();
    }

    public static <W> ImmutablePaginationRequestWrapperDto<W> copyOf(PaginationRequestWrapperDto<W> instance) {
        if (instance instanceof ImmutablePaginationRequestWrapperDto) {
            return (ImmutablePaginationRequestWrapperDto)instance;
        }
        return ImmutablePaginationRequestWrapperDto.builder().from(instance).build();
    }

    public static <W> Builder<W> builder() {
        return new Builder();
    }

    @Generated(from="PaginationRequestWrapperDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<W> {
        private static final long INIT_BIT_PAGE_NUMBER = 1L;
        private static final long INIT_BIT_ELEMENT_PER_PAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private Integer pageNumber;
        @Nullable
        private Integer elementPerPage;
        @Nullable
        private Optional<W> wrappedRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<W> from(PaginationRequestWrapperDto<W> instance) {
            Objects.requireNonNull(instance, "instance");
            this.pageNumber(instance.pageNumber());
            this.elementPerPage(instance.elementPerPage());
            this.wrappedRequest(instance.wrappedRequest());
            return this;
        }

        @JsonProperty(value="pageNumber")
        @CanIgnoreReturnValue
        public final Builder<W> pageNumber(Integer pageNumber) {
            this.pageNumber = Objects.requireNonNull(pageNumber, "pageNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="elementPerPage")
        @CanIgnoreReturnValue
        public final Builder<W> elementPerPage(Integer elementPerPage) {
            this.elementPerPage = Objects.requireNonNull(elementPerPage, "elementPerPage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="wrappedRequest")
        @CanIgnoreReturnValue
        public final Builder<W> wrappedRequest(Optional<W> wrappedRequest) {
            this.wrappedRequest = Objects.requireNonNull(wrappedRequest, "wrappedRequest");
            return this;
        }

        public ImmutablePaginationRequestWrapperDto<W> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaginationRequestWrapperDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pageNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("elementPerPage");
            }
            return "Cannot build PaginationRequestWrapperDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PaginationRequestWrapperDto", generator="Immutables")
    static final class Json<W>
    implements PaginationRequestWrapperDto<W> {
        @Nullable
        Integer pageNumber;
        @Nullable
        Integer elementPerPage;
        @Nullable
        Optional<W> wrappedRequest;

        Json() {
        }

        @JsonProperty(value="pageNumber")
        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @JsonProperty(value="elementPerPage")
        public void setElementPerPage(Integer elementPerPage) {
            this.elementPerPage = elementPerPage;
        }

        @JsonProperty(value="wrappedRequest")
        public void setWrappedRequest(Optional<W> wrappedRequest) {
            this.wrappedRequest = wrappedRequest;
        }

        @Override
        public Integer pageNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer elementPerPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<W> wrappedRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

