/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.scenario.campaign;

import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReportBuilder;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionReportCampaign;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CampaignExecutionReport {
    public final Long executionId;
    public final String campaignName;
    public final boolean partialExecution;
    public final String executionEnvironment;
    public final Optional<String> dataSetId;
    public final Optional<Integer> dataSetVersion;
    public final String userId;
    public final LocalDateTime startDate;
    private ServerReportStatus status;
    private final List<ScenarioExecutionReportCampaign> scenarioExecutionReports;
    public final Long campaignId;

    public CampaignExecutionReport(Long executionId, String campaignName, boolean partialExecution, String executionEnvironment, String dataSetId, Integer dataSetVersion, String userId) {
        this.executionId = executionId;
        this.campaignId = null;
        this.partialExecution = partialExecution;
        this.executionEnvironment = executionEnvironment;
        this.scenarioExecutionReports = new ArrayList<ScenarioExecutionReportCampaign>();
        this.campaignName = campaignName;
        this.startDate = LocalDateTime.now();
        this.status = ServerReportStatus.RUNNING;
        this.dataSetId = Optional.ofNullable(dataSetId);
        this.dataSetVersion = Optional.ofNullable(dataSetVersion);
        this.userId = userId;
    }

    public CampaignExecutionReport(Long executionId, Long campaignId, List<ScenarioExecutionReportCampaign> scenarioExecutionReports, String campaignName, boolean partialExecution, String executionEnvironment, String dataSetId, Integer dataSetVersion, String userId) {
        this.executionId = executionId;
        this.campaignId = campaignId;
        this.campaignName = campaignName;
        this.scenarioExecutionReports = scenarioExecutionReports;
        this.startDate = this.findStartDate(scenarioExecutionReports);
        this.status = this.findStatus(scenarioExecutionReports);
        this.partialExecution = partialExecution;
        this.executionEnvironment = executionEnvironment;
        this.dataSetId = Optional.ofNullable(dataSetId);
        this.dataSetVersion = Optional.ofNullable(dataSetVersion);
        this.userId = userId;
    }

    CampaignExecutionReport(Long executionId, Long campaignId, String campaignName, boolean partialExecution, String executionEnvironment, String userId, Optional<String> dataSetId, Optional<Integer> dataSetVersion, LocalDateTime startDate, ServerReportStatus status, List<ScenarioExecutionReportCampaign> scenarioExecutionReports) {
        this.executionId = executionId;
        this.campaignId = campaignId;
        this.campaignName = campaignName;
        this.partialExecution = partialExecution;
        this.executionEnvironment = executionEnvironment;
        this.dataSetId = dataSetId;
        this.dataSetVersion = dataSetVersion;
        this.userId = userId;
        if (scenarioExecutionReports == null) {
            this.startDate = Optional.ofNullable(startDate).orElse(LocalDateTime.now());
            this.status = Optional.ofNullable(status).orElse(ServerReportStatus.RUNNING);
            this.scenarioExecutionReports = null;
        } else {
            this.startDate = this.findStartDate(scenarioExecutionReports);
            this.status = this.findStatus(scenarioExecutionReports);
            this.scenarioExecutionReports = scenarioExecutionReports;
        }
    }

    public void initExecution(List<TestCase> testCases, String executionEnvironment, String userId) {
        testCases.forEach(testCase -> this.scenarioExecutionReports.add(new ScenarioExecutionReportCampaign(testCase.id(), testCase.metadata().title(), ImmutableExecutionHistory.ExecutionSummary.builder().executionId(-1L).testCaseTitle(testCase.metadata().title()).time(LocalDateTime.now()).status(ServerReportStatus.NOT_EXECUTED).duration(0L).environment(executionEnvironment).datasetId(this.dataSetId).datasetVersion(this.dataSetVersion).user(userId).build())));
    }

    public void startScenarioExecution(TestCase testCase, String executionEnvironment, String userId) throws UnsupportedOperationException {
        OptionalInt indexOpt = IntStream.range(0, this.scenarioExecutionReports.size()).filter(i -> this.scenarioExecutionReports.get((int)i).scenarioId.equals(testCase.id())).findFirst();
        this.scenarioExecutionReports.set(indexOpt.getAsInt(), new ScenarioExecutionReportCampaign(testCase.id(), testCase.metadata().title(), ImmutableExecutionHistory.ExecutionSummary.builder().executionId(-1L).testCaseTitle(testCase.metadata().title()).time(LocalDateTime.now()).status(ServerReportStatus.RUNNING).duration(0L).environment(executionEnvironment).datasetId(this.dataSetId).datasetVersion(this.dataSetVersion).user(userId).build()));
    }

    public void endScenarioExecution(ScenarioExecutionReportCampaign scenarioExecutionReportCampaign) throws UnsupportedOperationException {
        int index = this.scenarioExecutionReports.indexOf(scenarioExecutionReportCampaign);
        this.scenarioExecutionReports.set(index, scenarioExecutionReportCampaign);
    }

    public void endCampaignExecution() {
        if (!this.status.isFinal()) {
            this.status = this.findStatus(this.scenarioExecutionReports);
        }
    }

    public List<ScenarioExecutionReportCampaign> scenarioExecutionReports() {
        if (this.findStatus(this.scenarioExecutionReports).isFinal()) {
            this.scenarioExecutionReports.sort(ScenarioExecutionReportCampaign.executionIdComparator());
        }
        return Collections.unmodifiableList(this.scenarioExecutionReports);
    }

    public ServerReportStatus status() {
        return this.status;
    }

    public long getDuration() {
        Optional<LocalDateTime> latestExecutionEndDate = this.scenarioExecutionReports.stream().map(report -> report.execution.time().plus(report.execution.duration(), ChronoUnit.MILLIS)).max(LocalDateTime::compareTo);
        return latestExecutionEndDate.map(endDate -> ChronoUnit.MILLIS.between(this.startDate, (Temporal)endDate)).orElse(0L);
    }

    private LocalDateTime findStartDate(List<ScenarioExecutionReportCampaign> scenarioExecutionReports) {
        return scenarioExecutionReports.stream().filter(Objects::nonNull).map(report -> report.execution).filter(Objects::nonNull).map(ExecutionHistory.ExecutionProperties::time).filter(Objects::nonNull).reduce((time1, time2) -> {
            if (time1.isBefore((ChronoLocalDateTime<?>)time2)) {
                return time1;
            }
            return time2;
        }).orElse(LocalDateTime.MIN);
    }

    private ServerReportStatus findStatus(List<ScenarioExecutionReportCampaign> scenarioExecutionReports) {
        List<ScenarioExecutionReportCampaign> filteredReports = this.filterRetry(scenarioExecutionReports);
        ServerReportStatus foundStatus = filteredReports.stream().map(report -> report.execution).filter(Objects::nonNull).map(ExecutionHistory.ExecutionProperties::status).collect(Collectors.collectingAndThen(Collectors.toList(), ServerReportStatus::worst));
        if (foundStatus.equals((Object)ServerReportStatus.NOT_EXECUTED)) {
            return ServerReportStatus.STOPPED;
        }
        return foundStatus;
    }

    private List<ScenarioExecutionReportCampaign> filterRetry(List<ScenarioExecutionReportCampaign> scenarioExecutionReports) {
        return scenarioExecutionReports.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(s -> s.scenarioId)).values().stream().map(list -> list.size() == 1 ? (ScenarioExecutionReportCampaign)list.get(0) : list.stream().max(Comparator.comparing(objet -> objet.execution.time())).get()).toList();
    }

    public CampaignExecutionReport withoutRetries() {
        return CampaignExecutionReportBuilder.builder().setExecutionId(this.executionId).setCampaignId(this.campaignId).setCampaignName(this.campaignName).setExecutionEnvironment(this.executionEnvironment).setDataSetId(this.dataSetId.orElse(null)).setDataSetVersion(this.dataSetVersion.orElse(null)).setUserId(this.userId).setStartDate(this.startDate).setStatus(this.status).setScenarioExecutionReport(this.filterRetry(this.scenarioExecutionReports)).build();
    }

    public String toString() {
        return "CampaignExecutionReport{executionId=" + this.executionId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignExecutionReport that = (CampaignExecutionReport)o;
        return Objects.equals(this.executionId, that.executionId);
    }

    public int hashCode() {
        return Objects.hash(this.executionId);
    }
}

