/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.security;

import com.chutneytesting.server.core.domain.security.Authorization;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Role {
    public final String name;
    public final Set<Authorization> authorizations;

    private Role(String name, Set<Authorization> authorizations) {
        this.name = name;
        this.authorizations = authorizations;
    }

    public static Predicate<Role> roleByNamePredicate(String roleName) {
        return role -> role.name.equals(roleName);
    }

    public static List<Authorization> authorizations(List<Role> userRoles) {
        return userRoles.stream().flatMap(r -> r.authorizations.stream()).collect(Collectors.toList());
    }

    public static RoleBuilder builder() {
        return new RoleBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return this.name.equals(role.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Role{name='" + this.name + "', authorizations=" + this.authorizations + "}";
    }

    public static class RoleBuilder {
        private static final Predicate<String> ROLE_NAME_PREDICATE = Pattern.compile("^\\w+$").asMatchPredicate();
        private String name;
        private Set<String> authorizations;

        private RoleBuilder() {
        }

        public Role build() {
            return new Role(this.validateRoleName(), this.validateAuthorizations(this.authorizations));
        }

        public RoleBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public RoleBuilder withAuthorizations(Collection<String> authorizations) {
            if (Optional.ofNullable(authorizations).isPresent()) {
                this.authorizations = new LinkedHashSet<String>(authorizations);
            }
            return this;
        }

        private String validateRoleName() {
            String n = Optional.ofNullable(this.name).orElse("");
            if (!ROLE_NAME_PREDICATE.test(n)) {
                throw new IllegalArgumentException("Role name must be alphanumeric with underscores, i.e. must match the pattern `[0-9a-zA-Z_]+`");
            }
            return n;
        }

        private Set<Authorization> validateAuthorizations(Set<String> authorizations) {
            return Optional.ofNullable(authorizations).orElse(Collections.emptySet()).stream().map(Authorization::valueOf).collect(Collectors.toCollection(LinkedHashSet::new));
        }
    }
}

