/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.api;

import com.chutneytesting.jira.api.ImmutableJiraConfigurationDto;
import com.chutneytesting.jira.api.ImmutableJiraDto;
import com.chutneytesting.jira.api.ImmutableJiraTestExecutionDto;
import com.chutneytesting.jira.api.JiraConfigurationDto;
import com.chutneytesting.jira.api.JiraDto;
import com.chutneytesting.jira.api.JiraTestExecutionDto;
import com.chutneytesting.jira.domain.JiraRepository;
import com.chutneytesting.jira.domain.JiraServerConfiguration;
import com.chutneytesting.jira.domain.JiraXrayService;
import com.chutneytesting.jira.xrayapi.XrayTestExecTest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/jira/v1/"})
@CrossOrigin(origins={"*"})
public class JiraModuleController {
    public static final String BASE_URL = "/api/ui/jira/v1/";
    public static final String BASE_SCENARIO_URL = "scenario";
    public static final String BASE_CAMPAIGN_URL = "campaign";
    public static final String BASE_CAMPAIGN_EXEC_URL = "campaign_execution";
    public static final String BASE_TEST_EXEC_URL = "testexec";
    public static final String BASE_CONFIGURATION_URL = "configuration";
    private final JiraRepository jiraRepository;
    private final JiraXrayService jiraXrayService;

    public JiraModuleController(JiraRepository jiraRepository, JiraXrayService jiraXrayService) {
        this.jiraRepository = jiraRepository;
        this.jiraXrayService = jiraXrayService;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ') or hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={"scenario"}, produces={"application/json"})
    public Map<String, String> getLinkedScenarios() {
        return this.jiraRepository.getAllLinkedScenarios();
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"campaign"}, produces={"application/json"})
    public Map<String, String> getLinkedCampaigns() {
        return this.jiraRepository.getAllLinkedCampaigns();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @GetMapping(path={"scenario/{scenarioId}"}, produces={"application/json"})
    public JiraDto getByScenarioId(@PathVariable String scenarioId) {
        String jiraId = this.jiraRepository.getByScenarioId(scenarioId);
        return ImmutableJiraDto.builder().id(jiraId).chutneyId(scenarioId).build();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @PostMapping(path={"scenario"}, consumes={"application/json"}, produces={"application/json"})
    public JiraDto saveForScenario(@RequestBody JiraDto jiraDto) {
        this.jiraRepository.saveForScenario(jiraDto.chutneyId(), jiraDto.id());
        return ImmutableJiraDto.builder().id(jiraDto.id()).chutneyId(jiraDto.chutneyId()).build();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @DeleteMapping(path={"scenario/{scenarioId}"})
    public void removeForScenario(@PathVariable String scenarioId) {
        this.jiraRepository.removeForScenario(scenarioId);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"campaign/{campaignId}"}, produces={"application/json"})
    public JiraDto getByCampaignId(@PathVariable String campaignId) {
        String jiraId = this.jiraRepository.getByCampaignId(campaignId);
        return ImmutableJiraDto.builder().id(jiraId).chutneyId(campaignId).build();
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={"testexec/{testExecId}"}, produces={"application/json"})
    public List<JiraDto> getScenariosByTestExecutionId(@PathVariable String testExecId) {
        if (testExecId.isEmpty()) {
            return new ArrayList<JiraDto>();
        }
        Map<String, String> allLinkedScenarios = this.jiraRepository.getAllLinkedScenarios();
        Map collect = this.jiraXrayService.getTestExecutionScenarios(testExecId).stream().collect(Collectors.toMap(XrayTestExecTest::getKey, Function.identity()));
        return allLinkedScenarios.entrySet().stream().filter(entry -> collect.get(entry.getValue()) != null).map(m -> ImmutableJiraDto.builder().id((String)m.getValue()).chutneyId((String)m.getKey()).executionStatus(Optional.ofNullable(((XrayTestExecTest)collect.get(m.getValue())).getStatus())).build()).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={"campaign_execution/{campaignExecutionId}"}, produces={"application/json"})
    public JiraTestExecutionDto getScenariosByCampaignExecutionId(@PathVariable String campaignExecutionId) {
        if (campaignExecutionId.isEmpty()) {
            throw new IllegalArgumentException("Empty campaign execution id");
        }
        String testExecId = this.jiraRepository.getByCampaignExecutionId(campaignExecutionId);
        List<JiraDto> jiraDtoList = this.getScenariosByTestExecutionId(testExecId);
        return ImmutableJiraTestExecutionDto.builder().id(testExecId).jiraScenarios(jiraDtoList).build();
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PostMapping(path={"campaign"}, consumes={"application/json"}, produces={"application/json"})
    public JiraDto saveForCampaign(@RequestBody JiraDto jiraDto) {
        this.jiraRepository.saveForCampaign(jiraDto.chutneyId(), jiraDto.id());
        return ImmutableJiraDto.builder().id(jiraDto.id()).chutneyId(jiraDto.chutneyId()).build();
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @DeleteMapping(path={"campaign/{campaignId}"})
    public void removeForCampaign(@PathVariable String campaignId) {
        this.jiraRepository.removeForCampaign(campaignId);
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"configuration"}, produces={"application/json"})
    public JiraConfigurationDto getConfiguration() {
        JiraServerConfiguration jiraServerConfiguration = this.jiraRepository.loadServerConfiguration();
        return ImmutableJiraConfigurationDto.builder().url(jiraServerConfiguration.url()).username(jiraServerConfiguration.username()).password(jiraServerConfiguration.password()).urlProxy(jiraServerConfiguration.urlProxy()).userProxy(jiraServerConfiguration.userProxy()).passwordProxy(jiraServerConfiguration.passwordProxy()).build();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ') or hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"configuration/url"}, produces={"text/plain"})
    public String getConfigurationUrl() {
        JiraServerConfiguration jiraServerConfiguration = this.jiraRepository.loadServerConfiguration();
        return jiraServerConfiguration.url();
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(path={"configuration"}, consumes={"application/json"}, produces={"application/json"})
    public void saveConfiguration(@RequestBody JiraConfigurationDto jiraConfigurationDto) {
        this.jiraRepository.saveServerConfiguration(new JiraServerConfiguration(jiraConfigurationDto.url(), jiraConfigurationDto.username(), jiraConfigurationDto.password(), jiraConfigurationDto.urlProxy().orElse(null), jiraConfigurationDto.userProxy().orElse(null), jiraConfigurationDto.passwordProxy().orElse(null)));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PutMapping(path={"testexec/{testExecId}"}, produces={"application/json"}, consumes={"application/json"})
    public void updateScenarioStatus(@PathVariable String testExecId, @RequestBody JiraDto jiraDto) {
        if (!testExecId.isEmpty() && jiraDto.executionStatus().isPresent()) {
            this.jiraXrayService.updateScenarioStatus(testExecId, jiraDto.chutneyId(), jiraDto.executionStatus().get());
        }
    }
}

