/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.infra;

import com.chutneytesting.jira.domain.JiraRepository;
import com.chutneytesting.jira.domain.JiraTargetConfiguration;
import com.chutneytesting.jira.infra.JiraTargetConfigurationDto;
import com.chutneytesting.tools.file.FileUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class JiraFileRepository
implements JiraRepository {
    private static final String FILE_EXTENSION = ".json";
    private static final String SCENARIO_FILE = "scenario_link.json";
    private static final String CAMPAIGN_FILE = "campaign_link.json";
    private static final String CAMPAIGN_EXECUTION_FILE = "campaign_execution_link.json";
    private static final String CONFIGURATION_FILE = "jira_config.json";
    private final Path storeFolderPath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public JiraFileRepository(String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]);
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    @Override
    public Path getFolderPath() {
        return this.storeFolderPath;
    }

    @Override
    public Map<String, String> getAllLinkedCampaigns() {
        return this.getAll(CAMPAIGN_FILE);
    }

    @Override
    public Map<String, String> getAllLinkedScenarios() {
        return this.getAll(SCENARIO_FILE).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public String getByScenarioId(String scenarioId) {
        return this.getById(SCENARIO_FILE, scenarioId);
    }

    @Override
    public void saveForScenario(String scenarioId, String jiraId) {
        this.save(SCENARIO_FILE, scenarioId, jiraId);
    }

    @Override
    public void removeForScenario(String scenarioId) {
        this.remove(SCENARIO_FILE, scenarioId);
    }

    @Override
    public String getByCampaignId(String campaignId) {
        return this.getById(CAMPAIGN_FILE, campaignId);
    }

    @Override
    public void saveForCampaign(String campaignId, String jiraId) {
        this.save(CAMPAIGN_FILE, campaignId, jiraId);
    }

    @Override
    public void removeForCampaign(String campaignId) {
        this.remove(CAMPAIGN_FILE, campaignId);
    }

    @Override
    public String getByCampaignExecutionId(String campaignExecutionId) {
        return this.getById(CAMPAIGN_EXECUTION_FILE, campaignExecutionId);
    }

    @Override
    public void saveForCampaignExecution(String campaignExecutionId, String jiraId) {
        this.save(CAMPAIGN_EXECUTION_FILE, campaignExecutionId, jiraId);
    }

    @Override
    public void removeForCampaignExecution(String campaignExecutionId) {
        this.remove(CAMPAIGN_EXECUTION_FILE, campaignExecutionId);
    }

    @Override
    public JiraTargetConfiguration loadServerConfiguration() {
        JiraTargetConfigurationDto dto = this.doLoadServerConfiguration();
        return new JiraTargetConfiguration(dto.url, dto.username, dto.password, dto.urlProxy, dto.userProxy, dto.passwordProxy);
    }

    @Override
    public void saveServerConfiguration(JiraTargetConfiguration jiraTargetConfiguration) {
        JiraTargetConfigurationDto jiraTargetConfigurationDto = new JiraTargetConfigurationDto(jiraTargetConfiguration.url(), jiraTargetConfiguration.username(), jiraTargetConfiguration.password(), jiraTargetConfiguration.urlProxy(), jiraTargetConfiguration.userProxy(), jiraTargetConfiguration.passwordProxy());
        Path resolvedFilePath = this.storeFolderPath.resolve(CONFIGURATION_FILE);
        this.doSave(resolvedFilePath, jiraTargetConfigurationDto);
    }

    private JiraTargetConfigurationDto doLoadServerConfiguration() {
        Path configurationFilePath = this.storeFolderPath.resolve(CONFIGURATION_FILE);
        if (!Files.exists(configurationFilePath, new LinkOption[0])) {
            return new JiraTargetConfigurationDto();
        }
        try {
            byte[] bytes = Files.readAllBytes(configurationFilePath);
            try {
                return (JiraTargetConfigurationDto)this.objectMapper.readValue(bytes, JiraTargetConfigurationDto.class);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize configuration file: " + configurationFilePath, e);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + configurationFilePath, e);
        }
    }

    private String getById(String filePath, String id) {
        return this.getAll(filePath).getOrDefault(id, "");
    }

    private Map<String, String> getAll(String filePath) {
        Path resolvedFilePath = this.storeFolderPath.resolve(filePath);
        if (!Files.exists(resolvedFilePath, new LinkOption[0])) {
            return new HashMap<String, String>();
        }
        try {
            byte[] bytes = Files.readAllBytes(resolvedFilePath);
            try {
                return (Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize configuration file: " + resolvedFilePath, e);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + resolvedFilePath, e);
        }
    }

    private void save(String filePath, String chutneyId, String jiraId) {
        Path resolvedFilePath = this.storeFolderPath.resolve(filePath);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (Files.exists(resolvedFilePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(resolvedFilePath);
                map.putAll((Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<Map<String, String>>(){}));
            }
            if (jiraId.isEmpty()) {
                map.remove(chutneyId);
            } else {
                map.put(chutneyId, jiraId);
            }
            this.doSave(resolvedFilePath, map);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + resolvedFilePath, e);
        }
    }

    private void doSave(Path path, Object map) {
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(map);
            try {
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write in configuration directory: " + this.storeFolderPath, e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + map, e);
        }
    }

    private void remove(String filePath, String chutneyId) {
        Path resolvedFilePath = this.storeFolderPath.resolve(filePath);
        try {
            HashMap map = new HashMap();
            if (Files.exists(resolvedFilePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(resolvedFilePath);
                map.putAll((Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<Map<String, String>>(){}));
            }
            map.remove(chutneyId);
            this.doSave(resolvedFilePath, map);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + resolvedFilePath, e);
        }
    }
}

