/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.infra;

import com.chutneytesting.jira.domain.JiraRepository;
import com.chutneytesting.server.core.domain.admin.Backupable;
import com.chutneytesting.server.core.domain.tools.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class JiraBackupRepository
implements Backupable {
    private final JiraRepository jiraRepository;

    public JiraBackupRepository(JiraRepository jiraRepository) {
        this.jiraRepository = jiraRepository;
    }

    public void backup(OutputStream outputStream) {
        Path fp;
        Optional<Path> folderPath = Optional.ofNullable(this.jiraRepository.getFolderPath());
        if (folderPath.isPresent() && StringUtils.isNotBlank((CharSequence)(fp = folderPath.get()).toString())) {
            try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
                ZipUtils.compressDirectoryToZipfile((Path)fp.getParent(), (Path)fp.getFileName(), (ZipOutputStream)zipOutPut);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public String name() {
        return "jiralinks";
    }
}

