/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.api;

import com.chutneytesting.jira.api.JiraDto;
import com.chutneytesting.jira.api.JiraTestExecutionDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JiraTestExecutionDto", generator="Immutables")
@Immutable
public final class ImmutableJiraTestExecutionDto
implements JiraTestExecutionDto {
    private final String id;
    private final List<JiraDto> jiraScenarios;

    private ImmutableJiraTestExecutionDto(String id, List<JiraDto> jiraScenarios) {
        this.id = id;
        this.jiraScenarios = jiraScenarios;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="jiraScenarios")
    public List<JiraDto> jiraScenarios() {
        return this.jiraScenarios;
    }

    public final ImmutableJiraTestExecutionDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableJiraTestExecutionDto(newValue, this.jiraScenarios);
    }

    public final ImmutableJiraTestExecutionDto withJiraScenarios(JiraDto ... elements) {
        List<JiraDto> newValue = ImmutableJiraTestExecutionDto.createUnmodifiableList(false, ImmutableJiraTestExecutionDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJiraTestExecutionDto(this.id, newValue);
    }

    public final ImmutableJiraTestExecutionDto withJiraScenarios(Iterable<? extends JiraDto> elements) {
        if (this.jiraScenarios == elements) {
            return this;
        }
        List<JiraDto> newValue = ImmutableJiraTestExecutionDto.createUnmodifiableList(false, ImmutableJiraTestExecutionDto.createSafeList(elements, true, false));
        return new ImmutableJiraTestExecutionDto(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJiraTestExecutionDto && this.equalTo(0, (ImmutableJiraTestExecutionDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableJiraTestExecutionDto another) {
        return this.id.equals(another.id) && this.jiraScenarios.equals(another.jiraScenarios);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.jiraScenarios.hashCode();
        return h;
    }

    public String toString() {
        return "JiraTestExecutionDto{id=" + this.id + ", jiraScenarios=" + this.jiraScenarios + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJiraTestExecutionDto fromJson(Json json) {
        Builder builder = ImmutableJiraTestExecutionDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.jiraScenarios != null) {
            builder.addAllJiraScenarios(json.jiraScenarios);
        }
        return builder.build();
    }

    public static ImmutableJiraTestExecutionDto copyOf(JiraTestExecutionDto instance) {
        if (instance instanceof ImmutableJiraTestExecutionDto) {
            return (ImmutableJiraTestExecutionDto)instance;
        }
        return ImmutableJiraTestExecutionDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="JiraTestExecutionDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private List<JiraDto> jiraScenarios = new ArrayList<JiraDto>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JiraTestExecutionDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.addAllJiraScenarios(instance.jiraScenarios());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addJiraScenarios(JiraDto element) {
            this.jiraScenarios.add(Objects.requireNonNull(element, "jiraScenarios element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addJiraScenarios(JiraDto ... elements) {
            for (JiraDto element : elements) {
                this.jiraScenarios.add(Objects.requireNonNull(element, "jiraScenarios element"));
            }
            return this;
        }

        @JsonProperty(value="jiraScenarios")
        @CanIgnoreReturnValue
        public final Builder jiraScenarios(Iterable<? extends JiraDto> elements) {
            this.jiraScenarios.clear();
            return this.addAllJiraScenarios(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllJiraScenarios(Iterable<? extends JiraDto> elements) {
            for (JiraDto jiraDto : elements) {
                this.jiraScenarios.add(Objects.requireNonNull(jiraDto, "jiraScenarios element"));
            }
            return this;
        }

        public ImmutableJiraTestExecutionDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJiraTestExecutionDto(this.id, ImmutableJiraTestExecutionDto.createUnmodifiableList(true, this.jiraScenarios));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build JiraTestExecutionDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JiraTestExecutionDto", generator="Immutables")
    static final class Json
    implements JiraTestExecutionDto {
        @Nullable
        String id;
        @Nullable
        List<JiraDto> jiraScenarios = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="jiraScenarios")
        public void setJiraScenarios(List<JiraDto> jiraScenarios) {
            this.jiraScenarios = jiraScenarios;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<JiraDto> jiraScenarios() {
            throw new UnsupportedOperationException();
        }
    }
}

