/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.infra;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.chutneytesting.jira.domain.JiraTargetConfiguration;
import com.chutneytesting.jira.domain.JiraXrayApi;
import com.chutneytesting.jira.domain.exception.NoJiraConfigurationException;
import com.chutneytesting.jira.xrayapi.JiraIssueType;
import com.chutneytesting.jira.xrayapi.Xray;
import com.chutneytesting.jira.xrayapi.XrayTestExecTest;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpJiraXrayImpl
implements JiraXrayApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpJiraXrayImpl.class);
    private static final int MS_TIMEOUT = 10000;
    private final JiraTargetConfiguration jiraTargetConfiguration;

    public HttpJiraXrayImpl(JiraTargetConfiguration jiraTargetConfiguration) {
        this.jiraTargetConfiguration = jiraTargetConfiguration;
        if (!jiraTargetConfiguration.isValid()) {
            throw new NoJiraConfigurationException();
        }
    }

    @Override
    public void updateRequest(Xray xray) {
        String updateUri = this.jiraTargetConfiguration.url() + "/rest/raven/1.0/import/execution";
        RestTemplate restTemplate = this.buildRestTemplate(this.jiraTargetConfiguration.username(), this.jiraTargetConfiguration.password());
        try {
            ResponseEntity response = restTemplate.postForEntity(updateUri, (Object)xray, String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                LOGGER.debug(response.toString());
                LOGGER.info("Xray successfully updated for " + xray.getTestExecutionKey());
            } else {
                LOGGER.error(response.toString());
            }
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to update test execution [" + xray.getTestExecutionKey() + "] : ", e);
        }
    }

    @Override
    public List<XrayTestExecTest> getTestExecutionScenarios(String xrayId) {
        List<XrayTestExecTest> tests = new ArrayList<XrayTestExecTest>();
        String uriTemplate = this.jiraTargetConfiguration.url() + "/rest/raven/1.0/api/%s/%s/test";
        String uri = String.format(uriTemplate, this.isTestPlan(xrayId) ? "testplan" : "testexec", xrayId);
        RestTemplate restTemplate = this.buildRestTemplate(this.jiraTargetConfiguration.username(), this.jiraTargetConfiguration.password());
        try {
            ResponseEntity response = restTemplate.getForEntity(uri, XrayTestExecTest[].class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK) && response.getBody() != null) {
                tests = Arrays.stream((XrayTestExecTest[])response.getBody()).toList();
            } else {
                LOGGER.error(response.toString());
            }
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to get xray test execution[" + xrayId + "] scenarios : ", e);
        }
        return tests;
    }

    @Override
    public void updateStatusByTestRunId(String testRuntId, String executionStatus) {
        String uriTemplate = this.jiraTargetConfiguration.url() + "/rest/raven/1.0/api/testrun/%s/status?status=%s";
        String uri = String.format(uriTemplate, testRuntId, executionStatus);
        RestTemplate restTemplate = this.buildRestTemplate(this.jiraTargetConfiguration.username(), this.jiraTargetConfiguration.password());
        try {
            restTemplate.put(uri, null, new Object[0]);
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to update xray testRuntId[" + testRuntId + "] with status[" + executionStatus + "] : ", e);
        }
    }

    @Override
    public void associateTestExecutionFromTestPlan(String testPlanId, String testExecutionId) {
        String uriTemplate = this.jiraTargetConfiguration.url() + "/rest/raven/1.0/api/testplan/%s/testexecution";
        String uri = String.format(uriTemplate, testPlanId);
        RestTemplate restTemplate = this.buildRestTemplate(this.jiraTargetConfiguration.username(), this.jiraTargetConfiguration.password());
        try {
            ResponseEntity response = restTemplate.postForEntity(uri, Map.of("add", List.of(testExecutionId)), String.class, new Object[0]);
            if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
                LOGGER.error(response.toString());
                throw new RuntimeException("Unable to associate test execution [" + testExecutionId + "] from test plan [" + testPlanId + "]");
            }
            LOGGER.debug(response.toString());
            LOGGER.info("Xray successfully associate test execution [" + testExecutionId + "] from test plan [" + testPlanId + "]");
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to associate test execution [" + testExecutionId + "] from test plan [" + testPlanId + "] : ", e);
        }
    }

    @Override
    public String createTestExecution(String testPlanId) {
        String string;
        block8: {
            Issue parentIssue = this.getIssue(testPlanId);
            IssueInputBuilder issueInputBuilder = new IssueInputBuilder();
            IssueInput issueInput = issueInputBuilder.setProjectKey(parentIssue.getProject().getKey()).setIssueTypeId(this.getIssueTypeByName("Test Execution").getId()).setSummary(parentIssue.getSummary()).build();
            JiraRestClient jiraRestClient = this.getJiraRestClient();
            try {
                BasicIssue issue = (BasicIssue)jiraRestClient.getIssueClient().createIssue(issueInput).claim();
                this.associateTestExecutionFromTestPlan(testPlanId, issue.getKey());
                string = issue.getKey();
                if (jiraRestClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jiraRestClient != null) {
                        try {
                            jiraRestClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create test execution issue from test plan [" + testPlanId + "] : ", e);
                }
            }
            jiraRestClient.close();
        }
        return string;
    }

    @Override
    public boolean isTestPlan(String issueId) {
        return this.getIssue(issueId).getIssueType().getId().equals(this.getIssueTypeByName("Test Plan").getId());
    }

    private Issue getIssue(String issueKey) {
        Issue issue;
        block8: {
            JiraRestClient jiraRestClient = this.getJiraRestClient();
            try {
                issue = (Issue)jiraRestClient.getIssueClient().getIssue(issueKey).claim();
                if (jiraRestClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jiraRestClient != null) {
                        try {
                            jiraRestClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to get issue [" + issueKey + "] : ", e);
                }
            }
            jiraRestClient.close();
        }
        return issue;
    }

    private JiraIssueType getIssueTypeByName(String issueTypeName) {
        String uri = this.jiraTargetConfiguration.url() + "/rest/api/latest/issuetype";
        Optional<Object> issueTypeOptional = Optional.empty();
        RestTemplate restTemplate = this.buildRestTemplate(this.jiraTargetConfiguration.username(), this.jiraTargetConfiguration.password());
        try {
            ResponseEntity response = restTemplate.getForEntity(uri, JiraIssueType[].class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK) && response.getBody() != null) {
                issueTypeOptional = Arrays.stream((JiraIssueType[])response.getBody()).filter(issueType -> issueType.getName().equals(issueTypeName)).findFirst();
            } else {
                LOGGER.error(response.toString());
            }
        }
        catch (RestClientException e) {
            throw new RuntimeException("Unable to get issues type list : ", e);
        }
        return (JiraIssueType)issueTypeOptional.orElseThrow(() -> new RuntimeException("Unable to get issue type [" + issueTypeName + "]"));
    }

    private SSLContext buildSslContext() {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> true);
            return sslContextBuilder.build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private RestTemplate buildRestTemplate(String username, String password) {
        SSLContext sslContext = this.buildSslContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setReadTimeout(10000);
        requestFactory.setConnectTimeout(10000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(username, password));
        return restTemplate;
    }

    private JiraRestClient getJiraRestClient() {
        try {
            AsynchronousJiraRestClientFactory asynchronousJiraRestClientFactory = new AsynchronousJiraRestClientFactory();
            return asynchronousJiraRestClientFactory.createWithBasicHttpAuthentication(new URI(this.jiraTargetConfiguration.url()), this.jiraTargetConfiguration.username(), this.jiraTargetConfiguration.password());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to instantiate Jira rest client from url [" + this.jiraTargetConfiguration.url() + "] : ", e);
        }
    }
}

