/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.api;

import com.chutneytesting.jira.api.JiraDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JiraDto", generator="Immutables")
@Immutable
public final class ImmutableJiraDto
implements JiraDto {
    private final String id;
    private final String chutneyId;
    @Nullable
    private final String executionStatus;

    private ImmutableJiraDto(String id, String chutneyId, @Nullable String executionStatus) {
        this.id = id;
        this.chutneyId = chutneyId;
        this.executionStatus = executionStatus;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="chutneyId")
    public String chutneyId() {
        return this.chutneyId;
    }

    @Override
    @JsonProperty(value="executionStatus")
    public Optional<String> executionStatus() {
        return Optional.ofNullable(this.executionStatus);
    }

    public final ImmutableJiraDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableJiraDto(newValue, this.chutneyId, this.executionStatus);
    }

    public final ImmutableJiraDto withChutneyId(String value) {
        String newValue = Objects.requireNonNull(value, "chutneyId");
        if (this.chutneyId.equals(newValue)) {
            return this;
        }
        return new ImmutableJiraDto(this.id, newValue, this.executionStatus);
    }

    public final ImmutableJiraDto withExecutionStatus(String value) {
        String newValue = Objects.requireNonNull(value, "executionStatus");
        if (Objects.equals(this.executionStatus, newValue)) {
            return this;
        }
        return new ImmutableJiraDto(this.id, this.chutneyId, newValue);
    }

    public final ImmutableJiraDto withExecutionStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.executionStatus, value)) {
            return this;
        }
        return new ImmutableJiraDto(this.id, this.chutneyId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJiraDto && this.equalTo(0, (ImmutableJiraDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableJiraDto another) {
        return this.id.equals(another.id) && this.chutneyId.equals(another.chutneyId) && Objects.equals(this.executionStatus, another.executionStatus);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.chutneyId.hashCode();
        h += (h << 5) + Objects.hashCode(this.executionStatus);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JiraDto{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("chutneyId=").append(this.chutneyId);
        if (this.executionStatus != null) {
            builder.append(", ");
            builder.append("executionStatus=").append(this.executionStatus);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJiraDto fromJson(Json json) {
        Builder builder = ImmutableJiraDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.chutneyId != null) {
            builder.chutneyId(json.chutneyId);
        }
        if (json.executionStatus != null) {
            builder.executionStatus(json.executionStatus);
        }
        return builder.build();
    }

    public static ImmutableJiraDto copyOf(JiraDto instance) {
        if (instance instanceof ImmutableJiraDto) {
            return (ImmutableJiraDto)instance;
        }
        return ImmutableJiraDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JiraDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CHUTNEY_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String chutneyId;
        @Nullable
        private String executionStatus;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JiraDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.chutneyId(instance.chutneyId());
            Optional<String> executionStatusOptional = instance.executionStatus();
            if (executionStatusOptional.isPresent()) {
                this.executionStatus(executionStatusOptional);
            }
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="chutneyId")
        @CanIgnoreReturnValue
        public final Builder chutneyId(String chutneyId) {
            this.chutneyId = Objects.requireNonNull(chutneyId, "chutneyId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = Objects.requireNonNull(executionStatus, "executionStatus");
            return this;
        }

        @JsonProperty(value="executionStatus")
        @CanIgnoreReturnValue
        public final Builder executionStatus(Optional<String> executionStatus) {
            this.executionStatus = executionStatus.orElse(null);
            return this;
        }

        public ImmutableJiraDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJiraDto(this.id, this.chutneyId, this.executionStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chutneyId");
            }
            return "Cannot build JiraDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JiraDto", generator="Immutables")
    static final class Json
    implements JiraDto {
        @Nullable
        String id;
        @Nullable
        String chutneyId;
        @Nullable
        Optional<String> executionStatus = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="chutneyId")
        public void setChutneyId(String chutneyId) {
            this.chutneyId = chutneyId;
        }

        @JsonProperty(value="executionStatus")
        public void setExecutionStatus(Optional<String> executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chutneyId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> executionStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

