/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.jira.domain;

import com.chutneytesting.jira.api.ReportForJira;
import com.chutneytesting.jira.domain.JiraRepository;
import com.chutneytesting.jira.domain.JiraTargetConfiguration;
import com.chutneytesting.jira.domain.JiraXrayApi;
import com.chutneytesting.jira.domain.JiraXrayClientFactory;
import com.chutneytesting.jira.domain.XrayStatus;
import com.chutneytesting.jira.domain.exception.NoJiraConfigurationException;
import com.chutneytesting.jira.xrayapi.Xray;
import com.chutneytesting.jira.xrayapi.XrayEvidence;
import com.chutneytesting.jira.xrayapi.XrayInfo;
import com.chutneytesting.jira.xrayapi.XrayTest;
import com.chutneytesting.jira.xrayapi.XrayTestExecTest;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraXrayService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraXrayService.class);
    private final JiraRepository jiraRepository;
    private final JiraXrayClientFactory jiraXrayImplFactory;

    public JiraXrayService(JiraRepository jiraRepository, JiraXrayClientFactory jiraXrayImplFactory) {
        this.jiraRepository = jiraRepository;
        this.jiraXrayImplFactory = jiraXrayImplFactory;
    }

    public void updateTestExecution(Long campaignId, Long campaignExecutionId, String scenarioId, ReportForJira report) {
        JiraXrayApi jiraXrayApi = this.createHttpJiraXrayImpl();
        String testKey = this.jiraRepository.getByScenarioId(scenarioId);
        String testExecutionKey = this.jiraRepository.getByCampaignId(campaignId.toString());
        if (jiraXrayApi.isTestPlan(testExecutionKey)) {
            String newTestExecutionKey = this.jiraRepository.getByCampaignExecutionId(campaignExecutionId.toString());
            if (newTestExecutionKey.isEmpty()) {
                newTestExecutionKey = jiraXrayApi.createTestExecution(testExecutionKey);
            }
            testExecutionKey = newTestExecutionKey;
        }
        if (!testKey.isEmpty() && !testExecutionKey.isEmpty()) {
            LOGGER.info("Update xray test {} of test execution {}", (Object)testKey, (Object)testExecutionKey);
            this.jiraRepository.saveForCampaignExecution(campaignExecutionId.toString(), testExecutionKey);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ");
            XrayTest xrayTest = new XrayTest(testKey, report.startDate.atZone(ZoneId.systemDefault()).format(formatter), report.startDate.plusNanos(report.duration * 1000000L).atZone(ZoneId.systemDefault()).format(formatter), this.getErrors(report).toString(), report.status.equals("SUCCESS") ? XrayStatus.PASS.value : XrayStatus.FAIL.value);
            xrayTest.setEvidences(this.getEvidences(report.rootStep, ""));
            XrayInfo info = new XrayInfo(Collections.singletonList(report.environment));
            Xray xray = new Xray(testExecutionKey, Collections.singletonList(xrayTest), info);
            jiraXrayApi.updateRequest(xray);
        }
    }

    public List<XrayTestExecTest> getTestExecutionScenarios(String testExecutionId) {
        JiraXrayApi jiraXrayApi = this.createHttpJiraXrayImpl();
        return jiraXrayApi.getTestExecutionScenarios(testExecutionId);
    }

    public void updateScenarioStatus(String testExecId, String chutneyId, String executionStatus) {
        JiraXrayApi jiraXrayApi = this.createHttpJiraXrayImpl();
        String scenarioJiraId = this.jiraRepository.getByScenarioId(chutneyId);
        List<XrayTestExecTest> testExecutionScenarios = this.getTestExecutionScenarios(testExecId);
        Optional<XrayTestExecTest> foundTest = testExecutionScenarios.stream().filter(test -> scenarioJiraId.equals(test.getKey())).findFirst();
        foundTest.ifPresent(xrayTestExecTest -> jiraXrayApi.updateStatusByTestRunId(xrayTestExecTest.getId(), executionStatus));
    }

    private JiraXrayApi createHttpJiraXrayImpl() {
        JiraTargetConfiguration jiraTargetConfiguration = this.jiraRepository.loadServerConfiguration();
        if (!jiraTargetConfiguration.isValid()) {
            LOGGER.error("Unable to create xray http service, jira url is undefined");
            throw new NoJiraConfigurationException();
        }
        return this.jiraXrayImplFactory.create(jiraTargetConfiguration);
    }

    private List<String> getErrors(ReportForJira report) {
        ArrayList<String> errors = new ArrayList<String>();
        this.getErrors(report.rootStep, "").forEach((k, v) -> errors.add(k + " => " + v));
        return errors;
    }

    private Map<String, String> getErrors(ReportForJira.Step currentStep, String parentStep) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (!currentStep.errors.isEmpty()) {
            errors.put(parentStep + " > " + currentStep.name, currentStep.errors.stream().filter(s -> !s.startsWith("data:image/png")).toList().toString());
        }
        if (!currentStep.steps.isEmpty()) {
            currentStep.steps.forEach(subStep -> errors.putAll(this.getErrors((ReportForJira.Step)subStep, parentStep + " > " + currentStep.name)));
        }
        return errors;
    }

    private List<XrayEvidence> getEvidences(ReportForJira.Step currentStep, String parentStep) {
        ArrayList<XrayEvidence> evidences = new ArrayList<XrayEvidence>();
        if (!currentStep.errors.isEmpty()) {
            evidences.addAll(currentStep.errors.stream().filter(s -> s.startsWith("data:image/png")).map(s -> new XrayEvidence(s.replace("data:image/png;base64,", ""), this.formatEvidenceFilename(parentStep, currentStep.name) + ".png", "image/png")).toList());
        }
        if (!currentStep.steps.isEmpty()) {
            currentStep.steps.forEach(subStep -> evidences.addAll(this.getEvidences((ReportForJira.Step)subStep, this.formatEvidenceFilename(parentStep, currentStep.name))));
        }
        return evidences;
    }

    private String formatEvidenceFilename(String parentStep, String stepName) {
        return parentStep.trim().replace(" ", "-") + (parentStep.trim().isEmpty() ? "" : "_") + stepName.trim().replace(" ", "-");
    }
}

