package com.chutneytesting.jira.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JiraDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJiraDto.builder()}.
 */
@Generated(from = "JiraDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJiraDto implements JiraDto {
  private final String id;
  private final String chutneyId;
  private final @Nullable String executionStatus;

  private ImmutableJiraDto(
      String id,
      String chutneyId,
      @Nullable String executionStatus) {
    this.id = id;
    this.chutneyId = chutneyId;
    this.executionStatus = executionStatus;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code chutneyId} attribute
   */
  @JsonProperty("chutneyId")
  @Override
  public String chutneyId() {
    return chutneyId;
  }

  /**
   * @return The value of the {@code executionStatus} attribute
   */
  @JsonProperty("executionStatus")
  @Override
  public Optional<String> executionStatus() {
    return Optional.ofNullable(executionStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraDto#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraDto withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableJiraDto(newValue, this.chutneyId, this.executionStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraDto#chutneyId() chutneyId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chutneyId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJiraDto withChutneyId(String value) {
    String newValue = Objects.requireNonNull(value, "chutneyId");
    if (this.chutneyId.equals(newValue)) return this;
    return new ImmutableJiraDto(this.id, newValue, this.executionStatus);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JiraDto#executionStatus() executionStatus} attribute.
   * @param value The value for executionStatus
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJiraDto withExecutionStatus(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "executionStatus");
    if (Objects.equals(this.executionStatus, newValue)) return this;
    return new ImmutableJiraDto(this.id, this.chutneyId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JiraDto#executionStatus() executionStatus} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for executionStatus
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJiraDto withExecutionStatus(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.executionStatus, value)) return this;
    return new ImmutableJiraDto(this.id, this.chutneyId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJiraDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJiraDto
        && equalTo(0, (ImmutableJiraDto) another);
  }

  private boolean equalTo(int synthetic, ImmutableJiraDto another) {
    return id.equals(another.id)
        && chutneyId.equals(another.chutneyId)
        && Objects.equals(executionStatus, another.executionStatus);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code chutneyId}, {@code executionStatus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + chutneyId.hashCode();
    h += (h << 5) + Objects.hashCode(executionStatus);
    return h;
  }

  /**
   * Prints the immutable value {@code JiraDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("JiraDto{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("chutneyId=").append(chutneyId);
    if (executionStatus != null) {
      builder.append(", ");
      builder.append("executionStatus=").append(executionStatus);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JiraDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JiraDto {
    @Nullable String id;
    @Nullable String chutneyId;
    @Nullable Optional<String> executionStatus = Optional.empty();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("chutneyId")
    public void setChutneyId(String chutneyId) {
      this.chutneyId = chutneyId;
    }
    @JsonProperty("executionStatus")
    public void setExecutionStatus(Optional<String> executionStatus) {
      this.executionStatus = executionStatus;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String chutneyId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> executionStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJiraDto fromJson(Json json) {
    ImmutableJiraDto.Builder builder = ImmutableJiraDto.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.chutneyId != null) {
      builder.chutneyId(json.chutneyId);
    }
    if (json.executionStatus != null) {
      builder.executionStatus(json.executionStatus);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JiraDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JiraDto instance
   */
  public static ImmutableJiraDto copyOf(JiraDto instance) {
    if (instance instanceof ImmutableJiraDto) {
      return (ImmutableJiraDto) instance;
    }
    return ImmutableJiraDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJiraDto ImmutableJiraDto}.
   * <pre>
   * ImmutableJiraDto.builder()
   *    .id(String) // required {@link JiraDto#id() id}
   *    .chutneyId(String) // required {@link JiraDto#chutneyId() chutneyId}
   *    .executionStatus(String) // optional {@link JiraDto#executionStatus() executionStatus}
   *    .build();
   * </pre>
   * @return A new ImmutableJiraDto builder
   */
  public static ImmutableJiraDto.Builder builder() {
    return new ImmutableJiraDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJiraDto ImmutableJiraDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JiraDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CHUTNEY_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String chutneyId;
    private @Nullable String executionStatus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JiraDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JiraDto instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      chutneyId(instance.chutneyId());
      Optional<String> executionStatusOptional = instance.executionStatus();
      if (executionStatusOptional.isPresent()) {
        executionStatus(executionStatusOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JiraDto#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraDto#chutneyId() chutneyId} attribute.
     * @param chutneyId The value for chutneyId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("chutneyId")
    public final Builder chutneyId(String chutneyId) {
      this.chutneyId = Objects.requireNonNull(chutneyId, "chutneyId");
      initBits &= ~INIT_BIT_CHUTNEY_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link JiraDto#executionStatus() executionStatus} to executionStatus.
     * @param executionStatus The value for executionStatus
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder executionStatus(String executionStatus) {
      this.executionStatus = Objects.requireNonNull(executionStatus, "executionStatus");
      return this;
    }

    /**
     * Initializes the optional value {@link JiraDto#executionStatus() executionStatus} to executionStatus.
     * @param executionStatus The value for executionStatus
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("executionStatus")
    public final Builder executionStatus(Optional<String> executionStatus) {
      this.executionStatus = executionStatus.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableJiraDto ImmutableJiraDto}.
     * @return An immutable instance of JiraDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJiraDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJiraDto(id, chutneyId, executionStatus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CHUTNEY_ID) != 0) attributes.add("chutneyId");
      return "Cannot build JiraDto, some of required attributes are not set " + attributes;
    }
  }
}
