/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.environment.dto;

import com.chutneytesting.environment.api.target.dto.TargetDto;
import com.chutneytesting.environment.api.variable.dto.EnvironmentVariableDto;
import com.chutneytesting.environment.api.variable.dto.EnvironmentVariableDtoMapper;
import com.chutneytesting.environment.domain.Environment;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnvironmentDto {
    public final String name;
    public final String description;
    public final List<TargetDto> targets;
    public final List<EnvironmentVariableDto> variables;

    public EnvironmentDto(String name) {
        this.name = name;
        this.description = null;
        this.targets = Collections.emptyList();
        this.variables = Collections.emptyList();
    }

    public EnvironmentDto(String name, String description) {
        this.name = name;
        this.description = description;
        this.targets = Collections.emptyList();
        this.variables = Collections.emptyList();
    }

    public EnvironmentDto(String name, String description, List<TargetDto> targets) {
        this.name = name;
        this.description = description;
        this.targets = Optional.ofNullable(targets).map(Collections::unmodifiableList).orElse(Collections.emptyList());
        this.variables = Collections.emptyList();
    }

    @JsonCreator
    public EnvironmentDto(String name, String description, List<TargetDto> targets, List<EnvironmentVariableDto> variables) {
        this.name = name;
        this.description = description;
        this.targets = Optional.ofNullable(targets).map(Collections::unmodifiableList).orElse(Collections.emptyList());
        this.variables = Optional.ofNullable(variables).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    public static EnvironmentDto from(Environment environment) {
        List<TargetDto> targets = environment.targets.stream().map(TargetDto::from).collect(Collectors.toList());
        List<EnvironmentVariableDto> variables = environment.variables.stream().map(EnvironmentVariableDtoMapper.INSTANCE::fromDomain).collect(Collectors.toList());
        return new EnvironmentDto(environment.name, environment.description, targets, variables);
    }

    public Environment toEnvironment() {
        return Environment.builder().withName(this.name).withDescription(this.description).withTargets(Optional.ofNullable(this.targets).orElse(Collections.emptyList()).stream().map(t -> t.toTarget(this.name)).collect(Collectors.toSet())).withVariables(Optional.ofNullable(this.variables).orElse(Collections.emptyList()).stream().map(EnvironmentVariableDtoMapper.INSTANCE::toDomain).collect(Collectors.toSet())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentDto that = (EnvironmentDto)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.targets, that.targets) && Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targets, this.variables);
    }
}

