/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment;

import com.chutneytesting.environment.api.environment.EmbeddedEnvironmentApi;
import com.chutneytesting.environment.api.target.EmbeddedTargetApi;
import com.chutneytesting.environment.api.variable.EmbeddedVariableApi;
import com.chutneytesting.environment.domain.Environment;
import com.chutneytesting.environment.domain.EnvironmentRepository;
import com.chutneytesting.environment.domain.EnvironmentService;
import com.chutneytesting.environment.infra.JsonFilesEnvironmentRepository;

public class EnvironmentConfiguration {
    public static final String DEFAULT_ENV_NAME = "DEFAULT";
    private final EnvironmentRepository environmentRepository;
    private final EmbeddedEnvironmentApi environmentApi;
    private final EmbeddedTargetApi targetApi;
    private final EmbeddedVariableApi variableApi;

    public EnvironmentConfiguration(String storeFolderPath) {
        this.environmentRepository = this.createEnvironmentRepository(storeFolderPath);
        EnvironmentService environmentService = this.createEnvironmentService(this.environmentRepository);
        this.environmentApi = new EmbeddedEnvironmentApi(environmentService);
        this.targetApi = new EmbeddedTargetApi(environmentService);
        this.variableApi = new EmbeddedVariableApi(environmentService);
        this.createDefaultEnvironment(environmentService);
    }

    private void createDefaultEnvironment(EnvironmentService environmentService) {
        if (this.environmentRepository.listNames().isEmpty()) {
            environmentService.createEnvironment(Environment.builder().withName(DEFAULT_ENV_NAME).build());
        }
    }

    private EnvironmentRepository createEnvironmentRepository(String storeFolderPath) {
        return new JsonFilesEnvironmentRepository(storeFolderPath);
    }

    private EnvironmentService createEnvironmentService(EnvironmentRepository environmentRepository) {
        return new EnvironmentService(environmentRepository);
    }

    public EmbeddedEnvironmentApi getEmbeddedEnvironmentApi() {
        return this.environmentApi;
    }

    public EmbeddedTargetApi getEmbeddedTargetApi() {
        return this.targetApi;
    }

    public EmbeddedVariableApi getEmbeddedVariableApi() {
        return this.variableApi;
    }
}

