/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api;

import com.chutneytesting.environment.api.dto.EnvironmentDto;
import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.environment.domain.TargetFilter;
import com.chutneytesting.environment.domain.exception.AlreadyExistingEnvironmentException;
import com.chutneytesting.environment.domain.exception.AlreadyExistingTargetException;
import com.chutneytesting.environment.domain.exception.CannotDeleteEnvironmentException;
import com.chutneytesting.environment.domain.exception.EnvironmentNotFoundException;
import com.chutneytesting.environment.domain.exception.InvalidEnvironmentNameException;
import com.chutneytesting.environment.domain.exception.TargetNotFoundException;
import java.util.List;
import java.util.Set;

public interface EnvironmentApi {
    public Set<EnvironmentDto> listEnvironments();

    public Set<String> listEnvironmentsNames();

    public EnvironmentDto getEnvironment(String var1) throws EnvironmentNotFoundException;

    default public EnvironmentDto createEnvironment(EnvironmentDto environmentMetadataDto) throws InvalidEnvironmentNameException, AlreadyExistingEnvironmentException {
        return this.createEnvironment(environmentMetadataDto, false);
    }

    public EnvironmentDto createEnvironment(EnvironmentDto var1, boolean var2) throws InvalidEnvironmentNameException, AlreadyExistingEnvironmentException;

    public EnvironmentDto importEnvironment(EnvironmentDto var1);

    public void updateEnvironment(String var1, EnvironmentDto var2) throws InvalidEnvironmentNameException, EnvironmentNotFoundException;

    public void deleteEnvironment(String var1) throws EnvironmentNotFoundException, CannotDeleteEnvironmentException;

    public List<TargetDto> listTargets(TargetFilter var1) throws EnvironmentNotFoundException;

    public Set<String> listTargetsNames() throws EnvironmentNotFoundException;

    public TargetDto getTarget(String var1, String var2) throws EnvironmentNotFoundException, TargetNotFoundException;

    public void addTarget(TargetDto var1) throws EnvironmentNotFoundException, AlreadyExistingTargetException;

    public TargetDto importTarget(String var1, TargetDto var2);

    public void updateTarget(String var1, TargetDto var2) throws EnvironmentNotFoundException, TargetNotFoundException;

    public void deleteTarget(String var1, String var2) throws EnvironmentNotFoundException, TargetNotFoundException;

    public void deleteTarget(String var1) throws EnvironmentNotFoundException, TargetNotFoundException;
}

