/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.infra;

import com.chutneytesting.environment.infra.JsonFilesEnvironmentRepository;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateTargetSecurityExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateTargetSecurityExecutor.class);
    private final JsonFilesEnvironmentRepository environmentRepository;
    private final ObjectMapper om;

    public MigrateTargetSecurityExecutor(JsonFilesEnvironmentRepository environmentRepository) {
        this.environmentRepository = environmentRepository;
        this.om = new ObjectMapper();
    }

    public void execute() {
        LOGGER.info("Migrate targets security...");
        try {
            List environmentsToMigrate = this.environmentRepository.listNames().stream().filter(this.hasTargetWithSecurity()).collect(Collectors.toList());
            LOGGER.info("Environments to migrate: {}", environmentsToMigrate);
            for (String envName : environmentsToMigrate) {
                try {
                    this.environmentRepository.save(this.environmentRepository.findByName(envName));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot migrate targets securities of environment {}", (Object)envName, (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot migrate targets securities of environment", (Throwable)e);
        }
        LOGGER.info("Migrate targets security");
    }

    private Predicate<String> hasTargetWithSecurity() {
        return envName -> {
            Path environmentPath = this.environmentRepository.getEnvironmentPath((String)envName);
            try {
                byte[] bytes = Files.readAllBytes(environmentPath);
                JsonNode envRootNode = this.om.readTree(bytes);
                if (envRootNode.hasNonNull("targets")) {
                    Iterator targetsIter = envRootNode.get("targets").elements();
                    while (targetsIter.hasNext()) {
                        if (!((JsonNode)targetsIter.next()).hasNonNull("security")) continue;
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Cannot read configuration file: " + environmentPath, (Throwable)e);
            }
            return false;
        };
    }
}

