/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.dto;

import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.environment.domain.Environment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnvironmentDto {
    public final String name;
    public final String description;
    public final List<TargetDto> targets;

    public EnvironmentDto(String name) {
        this.name = name;
        this.description = null;
        this.targets = Collections.emptyList();
    }

    public EnvironmentDto(String name, String description, List<TargetDto> targets) {
        this.name = name;
        this.description = description;
        this.targets = Optional.ofNullable(targets).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    public static EnvironmentDto from(Environment environment) {
        List<TargetDto> targets = environment.targets.stream().map(TargetDto::from).collect(Collectors.toList());
        return new EnvironmentDto(environment.name, environment.description, targets);
    }

    public Environment toEnvironment() {
        return Environment.builder().withName(this.name).withDescription(this.description).withTargets(Optional.ofNullable(this.targets).orElse(Collections.emptyList()).stream().map(t -> t.toTarget(this.name)).collect(Collectors.toSet())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentDto that = (EnvironmentDto)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.targets, that.targets);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targets);
    }
}

