/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.dto;

import com.chutneytesting.environment.domain.Target;
import com.chutneytesting.tools.Entry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TargetDto {
    public final String name;
    public final String url;
    public final Set<Entry> properties;

    public TargetDto(String name, String url, Set<Entry> properties) {
        this.name = name.trim();
        this.url = url.trim();
        this.properties = this.nullToEmpty(properties);
    }

    public Target toTarget(String environment) {
        return Target.builder().withName(this.name).withEnvironment(environment).withUrl(this.url).withProperties(this.propertiesToMap()).build();
    }

    public static TargetDto from(Target target) {
        return new TargetDto(target.name, target.url, Entry.toEntrySet(target.properties));
    }

    public Map<String, String> propertiesToMap() {
        return this.properties.stream().collect(Collectors.toMap(p -> p.key, p -> p.value));
    }

    private <T> Set<T> nullToEmpty(Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }
}

