/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.dto;

import com.chutneytesting.environment.domain.SecurityInfo;
import com.chutneytesting.environment.domain.Target;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TargetDto {
    public final String name;
    public final String url;
    public final List<Entry> properties;
    public final String username;
    public final String password;
    public final String keyStore;
    public final String keyStorePassword;
    public final String privateKey;

    public TargetDto(@JsonProperty(value="name") String name, @JsonProperty(value="url") String url, @JsonProperty(value="properties") List<Entry> properties, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="keyStore") String keyStore, @JsonProperty(value="keyStorePassword") String keyStorePassword, @JsonProperty(value="privateKey") String privateKey) {
        this.name = name.trim();
        this.url = url.trim();
        this.properties = this.nullToEmpty(properties);
        this.username = this.emptyToNull(username);
        this.password = this.emptyToNull(password);
        this.keyStore = this.emptyToNull(keyStore);
        this.keyStorePassword = this.emptyToNull(keyStorePassword);
        this.privateKey = this.emptyToNull(privateKey);
    }

    public Target toTarget(String environment) {
        SecurityInfo.SecurityInfoBuilder securityInfo = SecurityInfo.builder().keyStore(this.keyStore).keyStorePassword(this.keyStorePassword).privateKey(this.privateKey);
        if (this.username != null || this.password != null) {
            securityInfo.credential(SecurityInfo.Credential.of(this.username, this.password));
        }
        return Target.builder().withName(this.name).withEnvironment(environment).withUrl(this.url).withProperties(this.propertiesToMap()).withSecurity(securityInfo.build()).build();
    }

    public static TargetDto from(Target target) {
        return new TargetDto(target.name, target.url, TargetDto.toEntryList(target.properties), Optional.ofNullable(target.security.credential).map(c -> c.username).orElse(null), Optional.ofNullable(target.security.credential).map(c -> c.password).orElse(null), Optional.ofNullable(target.security.keyStore).orElse(null), Optional.ofNullable(target.security.keyStorePassword).orElse(null), Optional.ofNullable(target.security.privateKey).orElse(null));
    }

    public Map<String, String> propertiesToMap() {
        return this.properties.stream().collect(Collectors.toMap(p -> p.key, p -> p.value));
    }

    public boolean hasCredential() {
        return !Strings.isNullOrEmpty((String)this.username) || !Strings.isNullOrEmpty((String)this.password);
    }

    private String emptyToNull(String s) {
        return "".equals(s) ? null : s;
    }

    private <T> List<T> nullToEmpty(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private static List<Entry> toEntryList(Map<String, String> properties) {
        return properties.entrySet().stream().map(e -> new Entry((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    public static class Entry {
        public final String key;
        public final String value;

        public Entry(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }
    }
}

