/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api;

import com.chutneytesting.environment.api.EmbeddedEnvironmentApi;
import com.chutneytesting.environment.api.EnvironmentApi;
import com.chutneytesting.environment.api.dto.EnvironmentDto;
import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.environment.domain.exception.AlreadyExistingEnvironmentException;
import com.chutneytesting.environment.domain.exception.AlreadyExistingTargetException;
import com.chutneytesting.environment.domain.exception.CannotDeleteEnvironmentException;
import com.chutneytesting.environment.domain.exception.EnvironmentNotFoundException;
import com.chutneytesting.environment.domain.exception.InvalidEnvironmentNameException;
import com.chutneytesting.environment.domain.exception.TargetNotFoundException;
import java.util.Set;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v2/environment"})
public class HttpEnvironmentApi
implements EnvironmentApi {
    private final EmbeddedEnvironmentApi embeddedApplication;

    HttpEnvironmentApi(EmbeddedEnvironmentApi embeddedApplication) {
        this.embeddedApplication = embeddedApplication;
    }

    @Override
    @GetMapping(path={""}, produces={"application/json;charset=UTF-8"})
    public Set<EnvironmentDto> listEnvironments() {
        return this.embeddedApplication.listEnvironments();
    }

    @Override
    @PostMapping(value={""})
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, AlreadyExistingEnvironmentException {
        return this.embeddedApplication.createEnvironment(environmentDto);
    }

    @Override
    @DeleteMapping(value={"/{environmentName}"})
    public void deleteEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException, CannotDeleteEnvironmentException {
        this.embeddedApplication.deleteEnvironment(environmentName);
    }

    @Override
    @PutMapping(value={"/{environmentName}"})
    public void updateEnvironment(@PathVariable(value="environmentName") String environmentName, @RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, EnvironmentNotFoundException {
        this.embeddedApplication.updateEnvironment(environmentName, environmentDto);
    }

    @Override
    @GetMapping(path={"/{environmentName}/target"}, produces={"application/json;charset=UTF-8"})
    public Set<TargetDto> listTargets(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException {
        return this.embeddedApplication.listTargets(environmentName);
    }

    @Override
    @GetMapping(path={"/target"}, produces={"application/json;charset=UTF-8"})
    public Set<TargetDto> listTargets() throws EnvironmentNotFoundException {
        return this.embeddedApplication.listTargets();
    }

    @Override
    @GetMapping(value={"/{environmentName}"})
    public EnvironmentDto getEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException {
        return this.embeddedApplication.getEnvironment(environmentName);
    }

    @Override
    @GetMapping(value={"/{environmentName}/target/{targetName}"})
    public TargetDto getTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        return this.embeddedApplication.getTarget(environmentName, targetName);
    }

    @Override
    @PostMapping(value={"/{environmentName}/target"})
    public void addTarget(@PathVariable(value="environmentName") String environmentName, @RequestBody TargetDto targetDto) throws EnvironmentNotFoundException, AlreadyExistingTargetException {
        this.embeddedApplication.addTarget(environmentName, targetDto);
    }

    @Override
    @DeleteMapping(value={"/{environmentName}/target/{targetName}"})
    public void deleteTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.embeddedApplication.deleteTarget(environmentName, targetName);
    }

    @Override
    @PutMapping(value={"/{environmentName}/target/{targetName}"})
    public void updateTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName, @RequestBody TargetDto targetDto) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.embeddedApplication.updateTarget(environmentName, targetName, targetDto);
    }
}

