/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.infrastructure.delegation;

import com.chutneytesting.engine.api.execution.StepExecutionReportDto;
import com.chutneytesting.engine.domain.delegation.CannotDelegateException;
import com.chutneytesting.engine.domain.delegation.ConnectionChecker;
import com.chutneytesting.engine.domain.delegation.DelegationClient;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.engine.domain.execution.engine.Dataset;
import com.chutneytesting.engine.domain.execution.engine.Environment;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReport;
import com.chutneytesting.engine.infrastructure.delegation.ExecutionRequestMapper;
import com.chutneytesting.engine.infrastructure.delegation.StepExecutionReportMapper;
import com.chutneytesting.engine.infrastructure.delegation.TcpConnectionChecker;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClient
implements DelegationClient {
    private final RestTemplate restTemplate = new RestTemplate();
    private final ConnectionChecker connectionChecker = new TcpConnectionChecker();

    public HttpClient() {
        this(null, null);
    }

    public HttpClient(String username, String password) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.findAndRegisterModules();
        this.restTemplate.setMessageConverters((List)Lists.newArrayList((Object[])new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter(objectMapper)}));
        this.addBasicAuth(username, password);
    }

    @Override
    public StepExecutionReport handDown(Step step, NamedHostAndPort delegate) throws CannotDelegateException {
        if (this.connectionChecker.canConnectTo(delegate)) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            Dataset dataset = new Dataset(Collections.emptyMap(), Collections.emptyList());
            Environment environment = new Environment((String)step.getScenarioContext().get("environment"));
            HttpEntity request = new HttpEntity((Object)ExecutionRequestMapper.from(step.definition(), dataset, environment), (MultiValueMap)headers);
            StepExecutionReportDto reportDto = (StepExecutionReportDto)this.restTemplate.postForObject("https://" + delegate.host() + ":" + delegate.port() + "/api/scenario/execution/v1", (Object)request, StepExecutionReportDto.class, new Object[0]);
            return StepExecutionReportMapper.fromDto(reportDto);
        }
        throw new CannotDelegateException("Unable to connect to " + delegate.name() + " at " + delegate.host() + ":" + delegate.port());
    }

    private void addBasicAuth(String user, String password) {
        if (Optional.ofNullable(user).isPresent()) {
            this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password));
        }
    }
}

