/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.step;

import com.chutneytesting.engine.domain.execution.report.Status;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class StepState {
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private Status status = Status.NOT_EXECUTED;
    private Instant startDate;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> informations = new ArrayList<String>();
    private String name;

    public StepState(String name) {
        this.name = name;
    }

    public StepState() {
    }

    void beginExecution() {
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
            if (Objects.isNull(this.startDate)) {
                this.startDate = Instant.now();
            }
            this.status = Status.RUNNING;
        }
    }

    void endExecution(boolean isParentStep) {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
            if (isParentStep) {
                this.status = Status.EXECUTED;
            }
        }
    }

    void stopExecution() {
        this.status = Status.STOPPED;
    }

    void pauseExecution() {
        this.status = Status.PAUSED;
    }

    void resumeExecution() {
        this.status = Status.RUNNING;
    }

    void errorOccurred(String ... message) {
        this.status = Status.FAILURE;
        this.errors.addAll(Lists.newArrayList((Object[])message));
    }

    void successOccurred(String ... message) {
        this.status = Status.SUCCESS;
        this.informations.addAll(Lists.newArrayList((Object[])message));
    }

    void reset() {
        this.status = Status.NOT_EXECUTED;
        this.informations.clear();
        this.errors.clear();
    }

    void startWatch() {
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
        }
    }

    void stopWatch() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
    }

    void addInformation(String ... message) {
        this.informations.addAll(Lists.newArrayList((Object[])message));
    }

    void addErrors(String ... message) {
        this.errors.addAll(Lists.newArrayList((Object[])message));
    }

    public Duration duration() {
        return Duration.of(this.stopwatch.elapsed(TimeUnit.MICROSECONDS), ChronoUnit.MICROS);
    }

    public Status status() {
        return this.status;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> errors() {
        return Collections.unmodifiableList(this.filterNullAndEmptyMessage(this.errors));
    }

    public List<String> informations() {
        return Collections.unmodifiableList(this.filterNullAndEmptyMessage(this.informations));
    }

    public Instant startDate() {
        return Optional.ofNullable(this.startDate).orElse(Instant.now());
    }

    private List<String> filterNullAndEmptyMessage(List<String> messages) {
        return Lists.newArrayList(messages).stream().filter(StringUtils::isNotEmpty).toList();
    }
}

