/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.strategies;

import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.StepDefinitionBuilder;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import com.chutneytesting.engine.domain.execution.strategies.StrategyProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class ForEachStrategy
implements StepExecutionStrategy {
    @Override
    public String getType() {
        return "for";
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        StepStrategyDefinition strategyDefinition = step.strategy().orElseThrow(() -> new IllegalArgumentException("Strategy definition cannot be empty"));
        List<Map<String, Object>> dataset = ForEachStrategy.getDataset(step, scenarioContext, strategyDefinition, step.dataEvaluator());
        String indexName = Optional.ofNullable(strategyDefinition.strategyProperties.get("index")).orElse("i");
        step.beginExecution(scenarioExecution);
        AtomicInteger index = new AtomicInteger(0);
        HashMap<String, Object> context = new HashMap<String, Object>(scenarioContext);
        context.putAll(localContext);
        step.resolveName(context);
        if (step.isParentStep()) {
            List<Step> subSteps = List.copyOf(step.subSteps());
            step.removeStepExecution();
            List<Pair> iterations = dataset.stream().map(iterationContext -> this.buildParentIteration(indexName, index.getAndIncrement(), step, subSteps, (Map<String, Object>)iterationContext)).peek(p -> step.addStepExecution((Step)p.getLeft())).toList();
            iterations.forEach(it -> {
                HashMap<String, Object> mergedContext = new HashMap<String, Object>(localContext);
                mergedContext.putAll((Map)it.getRight());
                DefaultStepExecutionStrategy.instance.execute(scenarioExecution, (Step)it.getLeft(), scenarioContext, mergedContext, strategies);
            });
        } else {
            List<Pair> iterations = dataset.stream().map(iterationContext -> this.buildIteration(indexName, index.getAndIncrement(), step, (Map<String, Object>)iterationContext)).peek(e -> step.addStepExecution((Step)e.getKey())).toList();
            iterations.forEach(it -> {
                HashMap<String, Object> mergedContext = new HashMap<String, Object>(localContext);
                mergedContext.putAll((Map)it.getRight());
                ((Step)it.getLeft()).execute(scenarioExecution, scenarioContext, mergedContext);
            });
        }
        step.endExecution(scenarioExecution);
        return step.status();
    }

    private static List<Map<String, Object>> getDataset(Step step, ScenarioContext scenarioContext, StepStrategyDefinition strategyDefinition, StepDataEvaluator evaluator) {
        List dataset = (List)step.dataEvaluator().evaluate(strategyDefinition.strategyProperties.get("dataset"), scenarioContext);
        if (dataset.isEmpty()) {
            throw new IllegalArgumentException("Step iteration cannot have empty dataset");
        }
        return dataset.stream().map(iterationData -> iterationData.entrySet().stream().map(e -> Map.entry((String)e.getKey(), evaluator.evaluate(e.getValue(), scenarioContext))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).toList();
    }

    private Pair<Step, Map<String, Object>> buildParentIteration(String indexName, Integer index, Step step, List<Step> subSteps, Map<String, Object> iterationContext) {
        StepDefinition newDef = this.iterationDefinition(indexName, index, step.definition(), new StepStrategyDefinition("", new StrategyProperties()));
        List<Step> newSubSteps = subSteps.stream().map(subStep -> this.buildIterationDefinition(indexName, index, subStep.dataEvaluator(), subStep.definition(), subStep.executor(), subStep.subSteps(), subStep.strategy().orElse(new StepStrategyDefinition("", new StrategyProperties())))).toList();
        return Pair.of((Object)new Step(step.dataEvaluator(), newDef, step.executor(), newSubSteps), iterationContext);
    }

    private Pair<Step, Map<String, Object>> buildIteration(String indexName, Integer index, Step step, Map<String, Object> iterationContext) {
        return Pair.of((Object)new Step(step.dataEvaluator(), this.iterationDefinition(indexName, index, step.definition(), new StepStrategyDefinition("", new StrategyProperties())), step.executor(), Collections.emptyList()), iterationContext);
    }

    private Step buildIterationDefinition(String indexName, Integer index, StepDataEvaluator dataEvaluator, StepDefinition definition, StepExecutor executor, List<Step> subStep, StepStrategyDefinition strategy) {
        StepDefinition iterationDefinition = this.iterationDefinition(indexName, index, definition, Optional.ofNullable(strategy).orElse(new StepStrategyDefinition("", new StrategyProperties())));
        return new Step(dataEvaluator, iterationDefinition, executor, subStep.stream().map(step -> this.buildIterationDefinition(indexName, index, step.dataEvaluator(), step.definition(), step.executor(), step.subSteps(), step.strategy().orElse(null))).collect(Collectors.toList()));
    }

    private StepDefinition iterationDefinition(String indexName, Integer index, StepDefinition definition, StepStrategyDefinition strategyDefinition) {
        return StepDefinitionBuilder.copyFrom(definition).withName(this.index(indexName, index, definition.name)).withInputs(this.index(indexName, index, definition.inputs())).withOutputs(this.index(indexName, index, definition.outputs)).withValidations(this.index(indexName, index, definition.validations)).withStrategy(strategyDefinition).withSteps(definition.steps.stream().map(subStep -> this.iterationDefinition(indexName, index, (StepDefinition)subStep, subStep.getStrategy().orElse(new StepStrategyDefinition("", new StrategyProperties())))).toList()).build();
    }

    private String index(String indexName, Integer index, String string) {
        return string.replace("<" + indexName + ">", index.toString());
    }

    private Map<String, Object> index(String indexName, Integer index, Map<String, Object> inputs) {
        return inputs.entrySet().stream().collect(Collectors.toMap(e -> this.index(indexName, index, (String)e.getKey()), e -> this.index(indexName, index, e.getValue())));
    }

    private List<Object> index(String indexName, Integer index, List<Object> inputs) {
        return inputs.stream().map(e -> this.index(indexName, index, e)).toList();
    }

    private Object index(String indexName, Integer index, Object value) {
        if (value instanceof Map) {
            return this.index(indexName, index, (Map)value);
        }
        if (value instanceof List) {
            return this.index(indexName, index, (List)value);
        }
        return this.index(indexName, index, (String)value);
    }
}

